/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.item.ItemStructureSaver;
import io.github.noeppi_noeppi.libx.network.PacketSerializer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class SaveStructureHandler {
    public static void handle(Message msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_183503_();
            String name = ItemStructureSaver.saveSchematic((Level)level, msg.stack, msg.ignoreAir, msg.name);
            ItemStack stack = ItemStructureSaver.removeTags(msg.stack);
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
            TranslatableComponent component = new TranslatableComponent("skyblockbuilder.schematic.saved", new Object[]{name});
            player.m_5661_((Component)component, true);
        });
        ctx.get().setPacketHandled(true);
    }

    public record Message(ItemStack stack, String name, boolean ignoreAir) {
    }

    public static class Serializer
    implements PacketSerializer<Message> {
        public Class<Message> messageClass() {
            return Message.class;
        }

        public void encode(Message msg, FriendlyByteBuf buffer) {
            buffer.m_130055_(msg.stack);
            buffer.m_130070_(msg.name);
            buffer.writeBoolean(msg.ignoreAir);
        }

        public Message decode(FriendlyByteBuf buffer) {
            return new Message(buffer.m_130267_(), buffer.m_130136_(Short.MAX_VALUE), buffer.readBoolean());
        }
    }
}

