/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.network.DeleteTagsHandler;
import de.melanx.skyblockbuilder.network.ProfilesUpdateHandler;
import de.melanx.skyblockbuilder.network.SaveStructureHandler;
import de.melanx.skyblockbuilder.network.SkyblockDataUpdateHandler;
import de.melanx.skyblockbuilder.network.UpdateTemplateNamesHandler;
import de.melanx.skyblockbuilder.util.RandomUtility;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.network.NetworkX;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

public class SkyNetwork
extends NetworkX {
    public SkyNetwork() {
        super((ModX)SkyblockBuilder.getInstance());
    }

    protected NetworkX.Protocol getProtocol() {
        return NetworkX.Protocol.of((String)"7");
    }

    protected void registerPackets() {
        this.register(new SaveStructureHandler.Serializer(), () -> SaveStructureHandler::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new DeleteTagsHandler.Serializer(), () -> DeleteTagsHandler::handle, NetworkDirection.PLAY_TO_SERVER);
        this.register(new SkyblockDataUpdateHandler.Serializer(), () -> SkyblockDataUpdateHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new ProfilesUpdateHandler.ProfilesUpdateSerializer(), () -> ProfilesUpdateHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
        this.register(new UpdateTemplateNamesHandler.Serializer(), () -> UpdateTemplateNamesHandler::handle, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void updateData(Level level) {
        if (!level.f_46443_) {
            for (ServerPlayer player : ((ServerLevel)level).m_142572_().m_6846_().m_11314_()) {
                this.updateData((Player)player);
            }
        }
    }

    public void updateData(Player player) {
        if (!player.m_20193_().f_46443_) {
            this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SkyblockDataUpdateHandler.Message(SkyblockSavedData.get(player.m_20193_()), player.m_36316_().getId()));
        }
    }

    public void deleteTags(ItemStack stack) {
        this.channel.sendToServer((Object)new DeleteTagsHandler.Message(stack));
    }

    public void saveStructure(ItemStack stack, String name, boolean ignoreAir) {
        this.channel.sendToServer((Object)new SaveStructureHandler.Message(stack, name, ignoreAir));
    }

    public void updateProfiles(Player player) {
        if (player.m_20193_().f_46443_) {
            return;
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ProfilesUpdateHandler.Message(this.getProfilesTag((ServerLevel)player.m_20193_())));
    }

    public void updateProfiles(Level level) {
        if (level.f_46443_) {
            return;
        }
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)new ProfilesUpdateHandler.Message(this.getProfilesTag((ServerLevel)level)));
    }

    public void updateTemplateNames(Player player, List<String> names) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new UpdateTemplateNamesHandler.Message(names));
    }

    public void updateTemplateNames(List<String> names) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)new UpdateTemplateNamesHandler.Message(names));
    }

    private CompoundTag getProfilesTag(ServerLevel level) {
        Set<GameProfile> profileCache = RandomUtility.getGameProfiles(level);
        CompoundTag profiles = new CompoundTag();
        ListTag tags = new ListTag();
        profileCache.forEach(profile -> {
            if (profile.getId() != null && profile.getName() != null) {
                CompoundTag tag = new CompoundTag();
                tag.m_128362_("Id", profile.getId());
                tag.m_128359_("Name", profile.getName());
                tags.add((Object)tag);
            }
        });
        profiles.m_128365_("Profiles", (Tag)tags);
        return profiles;
    }
}

