/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.TemplateConfig;
import de.melanx.skyblockbuilder.template.TemplateInfo;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ConfiguredTemplate {
    private final Set<BlockPos> defaultSpawns = new HashSet<BlockPos>();
    private StructureTemplate template;
    private String name;
    private String desc;
    private WorldUtil.Directions direction;

    public ConfiguredTemplate(TemplateInfo info) {
        StructureTemplate template = new StructureTemplate();
        try {
            File file = SkyPaths.TEMPLATES_DIR.resolve(info.file()).toFile();
            CompoundTag nbt = NbtIo.m_128937_((File)file);
            template.m_74638_(nbt);
        }
        catch (IOException e) {
            SkyblockBuilder.getLogger().error("Template with name " + info.file() + " is incorrect.", (Throwable)e);
        }
        this.template = template;
        this.defaultSpawns.addAll((Collection<BlockPos>)TemplateConfig.spawns.get(info.spawns()));
        this.name = info.name();
        this.desc = info.desc();
        this.direction = info.direction();
    }

    private ConfiguredTemplate() {
    }

    public StructureTemplate getTemplate() {
        return this.template;
    }

    public Set<BlockPos> getDefaultSpawns() {
        return this.defaultSpawns;
    }

    public String getName() {
        return this.name;
    }

    public Component getNameComponent() {
        return this.name.startsWith("{") && this.name.endsWith("}") ? new TranslatableComponent(this.name) : new TextComponent(this.name);
    }

    public Component getDescriptionComponent() {
        return this.desc.startsWith("{") && this.desc.endsWith("}") ? new TranslatableComponent(this.desc) : new TextComponent(this.desc);
    }

    public WorldUtil.Directions getDirection() {
        return this.direction;
    }

    @Nonnull
    public CompoundTag write(CompoundTag nbt) {
        CompoundTag template = this.template.m_74618_(new CompoundTag());
        ListTag spawns = new ListTag();
        for (BlockPos pos : this.defaultSpawns) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128347_("posX", (double)pos.m_123341_() + 0.5);
            posTag.m_128347_("posY", (double)pos.m_123342_());
            posTag.m_128347_("posZ", (double)pos.m_123343_() + 0.5);
            spawns.add((Object)posTag);
        }
        nbt.m_128365_("Template", (Tag)template);
        nbt.m_128365_("Spawns", (Tag)spawns);
        nbt.m_128359_("Name", this.name);
        nbt.m_128359_("Desc", this.desc);
        nbt.m_128359_("Direction", this.direction == null ? WorldUtil.Directions.SOUTH.toString() : this.direction.toString());
        return nbt;
    }

    public void read(CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        StructureTemplate template = new StructureTemplate();
        template.m_74638_(nbt.m_128469_("Template"));
        this.template = template;
        ListTag spawns = nbt.m_128437_("Spawns", 10);
        this.defaultSpawns.clear();
        for (Tag pos : spawns) {
            CompoundTag posTag = (CompoundTag)pos;
            this.defaultSpawns.add(new BlockPos(posTag.m_128459_("posX"), posTag.m_128459_("posY"), posTag.m_128459_("posZ")));
        }
        this.name = nbt.m_128461_("Name");
        this.desc = nbt.m_128461_("Desc");
        this.direction = WorldUtil.Directions.valueOf(nbt.m_128461_("Direction"));
    }

    public ConfiguredTemplate copy() {
        CompoundTag nbt = this.write(new CompoundTag());
        ConfiguredTemplate template = new ConfiguredTemplate();
        template.read(nbt);
        return template;
    }

    public static ConfiguredTemplate fromTag(@Nonnull CompoundTag nbt) {
        ConfiguredTemplate info = new ConfiguredTemplate();
        info.read(nbt);
        return info;
    }
}

