/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import de.melanx.skyblockbuilder.config.TemplateConfig;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateInfo;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TemplateLoader {
    private static final List<String> TEMPLATE_NAMES = new ArrayList<String>();
    private static final Map<String, ConfiguredTemplate> TEMPLATE_MAP = new HashMap<String, ConfiguredTemplate>();
    private static ConfiguredTemplate TEMPLATE;

    public static void updateTemplates() {
        try {
            TEMPLATE_NAMES.clear();
            TEMPLATE_MAP.clear();
            SkyPaths.copyTemplateFile();
            HashSet<String> takenNames = new HashSet<String>();
            for (TemplateInfo info : TemplateConfig.templates) {
                if (!TemplateConfig.spawns.containsKey(info.spawns())) {
                    throw new IllegalArgumentException("Spawn configuration \"" + info.spawns() + "\" is not defined: " + info.name());
                }
                if (!SkyPaths.TEMPLATES_DIR.resolve(info.file()).toFile().exists()) {
                    throw new IllegalArgumentException("Template file \"" + info.file() + "\" does not exist: " + info.name());
                }
                if (takenNames.contains(info.name().toLowerCase(Locale.ROOT))) {
                    throw new IllegalArgumentException("Template name \"" + info.name() + "\" is defined too many times.");
                }
                takenNames.add(info.name().toLowerCase(Locale.ROOT));
                ConfiguredTemplate template = new ConfiguredTemplate(info);
                TEMPLATE_NAMES.add(info.name());
                TEMPLATE_MAP.put(info.name().toLowerCase(Locale.ROOT), template);
            }
            if (TEMPLATE_MAP.size() == 0) {
                throw new IllegalStateException("You need at least one configured template.");
            }
            TEMPLATE = TEMPLATE == null ? TEMPLATE_MAP.get(TEMPLATE_NAMES.get(0).toLowerCase(Locale.ROOT)) : TemplateLoader.getConfiguredTemplate(TEMPLATE.getName());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load templates.", e);
        }
    }

    public static void updateTemplateNames(List<String> names) {
        TEMPLATE_NAMES.clear();
        TEMPLATE_NAMES.addAll(names);
    }

    public static List<String> getTemplateNames() {
        return TEMPLATE_NAMES;
    }

    public static List<ConfiguredTemplate> getConfiguredTemplates() {
        ArrayList<ConfiguredTemplate> templates = new ArrayList<ConfiguredTemplate>(TEMPLATE_MAP.values());
        templates.sort(Comparator.comparing(ConfiguredTemplate::getName));
        return templates;
    }

    public static void setTemplate(ConfiguredTemplate template) {
        TEMPLATE = template;
    }

    public static StructureTemplate getTemplate() {
        if (TEMPLATE == null) {
            throw new IllegalStateException("Tried to access template before set.");
        }
        return TEMPLATE.getTemplate();
    }

    @Nullable
    public static ConfiguredTemplate getConfiguredTemplate(String name) {
        return TEMPLATE_MAP.get(name.toLowerCase(Locale.ROOT));
    }

    public static ConfiguredTemplate getConfiguredTemplate() {
        return TEMPLATE;
    }

    public static Set<BlockPos> getCurrentSpawns() {
        return TEMPLATE.getDefaultSpawns();
    }
}

