/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.compat.CuriosCompat;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.fml.ModList;

public class RandomUtility {
    public static void dropInventories(Player player) {
        if (player.m_5833_() || player.m_7500_()) {
            return;
        }
        player.m_150109_().m_36071_();
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.dropInventory(player);
        }
    }

    public static String formattedCooldown(long ticks) {
        int realTime = (int)(ticks / 20L);
        int min = realTime / 60;
        String sec = String.format("%02d", realTime % 60);
        return String.format("%s:%s", min, sec);
    }

    public static Set<GameProfile> getGameProfiles(ServerLevel level) {
        MinecraftServer server = level.m_142572_();
        GameProfileCache profileCache = server.m_129927_();
        HashSet profiles = Sets.newHashSet();
        HashSet handledIds = Sets.newHashSet((Object[])new UUID[]{Util.f_137441_});
        profileCache.m_10976_().forEach(profileInfo -> {
            GameProfile profile = profileInfo.m_11028_();
            profiles.add(profile);
            handledIds.add(profile.getId());
        });
        for (Team team : SkyblockSavedData.get((Level)level).getTeams()) {
            for (UUID id : team.getPlayers()) {
                if (handledIds.contains(id)) continue;
                Optional gameProfile = profileCache.m_11002_(id);
                if (gameProfile.isPresent()) {
                    profiles.add((GameProfile)gameProfile.get());
                    continue;
                }
                GameProfile profile = server.m_129925_().fillProfileProperties(new GameProfile(id, null), true);
                if (profile.getName() != null) {
                    profileCache.m_10991_(profile);
                    profiles.add(profile);
                    continue;
                }
                profiles.add(new GameProfile(profile.getId(), "Unknown"));
            }
        }
        return profiles;
    }

    public static void fillTemplateFromWorld(StructureTemplate template, Level level, BlockPos pos, Vec3i box, boolean withEntities, Collection<Block> toIgnore) {
        if (box.m_123341_() >= 1 && box.m_123342_() >= 1 && box.m_123343_() >= 1) {
            BlockPos blockpos = pos.m_141952_(box).m_142082_(-1, -1, -1);
            ArrayList specialBlocks = Lists.newArrayList();
            ArrayList blocksWithTag = Lists.newArrayList();
            ArrayList normalBlocks = Lists.newArrayList();
            BlockPos minPos = new BlockPos(Math.min(pos.m_123341_(), blockpos.m_123341_()), Math.min(pos.m_123342_(), blockpos.m_123342_()), Math.min(pos.m_123343_(), blockpos.m_123343_()));
            BlockPos maxPos = new BlockPos(Math.max(pos.m_123341_(), blockpos.m_123341_()), Math.max(pos.m_123342_(), blockpos.m_123342_()), Math.max(pos.m_123343_(), blockpos.m_123343_()));
            template.f_74484_ = box;
            for (BlockPos actPos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
                BlockPos relPos = actPos.m_141950_((Vec3i)minPos);
                BlockState state = level.m_8055_(actPos);
                if (!toIgnore.isEmpty() && toIgnore.contains(state.m_60734_())) continue;
                BlockEntity blockEntity = level.m_7702_(actPos);
                StructureTemplate.StructureBlockInfo blockInfo = blockEntity != null ? new StructureTemplate.StructureBlockInfo(relPos, state, blockEntity.m_187481_()) : new StructureTemplate.StructureBlockInfo(relPos, state, null);
                StructureTemplate.m_74573_((StructureTemplate.StructureBlockInfo)blockInfo, (List)specialBlocks, (List)blocksWithTag, (List)normalBlocks);
            }
            List sortedBlocks = StructureTemplate.m_74614_((List)specialBlocks, (List)blocksWithTag, (List)normalBlocks);
            template.f_74482_.clear();
            template.f_74482_.add(new StructureTemplate.Palette(sortedBlocks));
            if (withEntities) {
                template.m_74500_(level, minPos, maxPos.m_142082_(1, 1, 1));
            } else {
                template.f_74483_.clear();
            }
        }
    }

    public static String normalize(String s) {
        return s.toLowerCase(Locale.ROOT).replaceAll("\\W+", "_");
    }

    public static String getFilePath(String folderPath, String name) {
        return RandomUtility.getFilePath(folderPath, name, "nbt");
    }

    public static String getFilePath(String folderPath, String name, String extension) {
        String filename;
        String filepath;
        int index = 0;
        do {
            filename = (name == null ? "template" : RandomUtility.normalize(name)) + (String)(index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(Paths.get(filepath = folderPath + "/" + filename, new String[0]), new LinkOption[0]));
        return filepath;
    }

    public static String shorten(@Nonnull Font font, String name, int length) {
        Object s = name;
        int k = 0;
        while (font.m_92895_((String)s) > length) {
            s = name.substring(0, name.length() - k).trim() + "...";
            ++k;
        }
        return s;
    }
}

