/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.StartingInventory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class SkyPaths {
    public static final Path MOD_CONFIG = FMLPaths.CONFIGDIR.get().resolve("skyblockbuilder");
    public static final Path MOD_EXPORTS = FMLPaths.GAMEDIR.get().resolve("skyblock_exports");
    public static final Path TEMPLATES_DIR = MOD_CONFIG.resolve("templates");
    public static final Path ICONS_DIR = TEMPLATES_DIR.resolve("icons");
    public static final Path DATA_DIR = MOD_CONFIG.resolve("data");
    public static final Path ITEMS_FILE = MOD_CONFIG.resolve("starter_item.json");
    public static final Path SCHEMATIC_FILE = TEMPLATES_DIR.resolve("default.nbt");
    private static final Path FEATURES_FILE = DATA_DIR.resolve("features.txt");
    private static final Path STRUCTURES_FILE = DATA_DIR.resolve("structures.txt");
    private static final Path BIOMES_FILE = DATA_DIR.resolve("biomes.txt");
    private static final Path DIMENSIONS_FILE = DATA_DIR.resolve("dimensions.txt");

    public static void createDirectories() {
        try {
            Files.createDirectories(MOD_CONFIG, new FileAttribute[0]);
            Files.createDirectories(MOD_EXPORTS, new FileAttribute[0]);
            Files.createDirectories(TEMPLATES_DIR, new FileAttribute[0]);
            Files.createDirectories(ICONS_DIR, new FileAttribute[0]);
            Files.createDirectories(DATA_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create default directories.", e);
        }
    }

    public static void generateDefaultFiles(@Nullable MinecraftServer server) {
        try {
            SkyPaths.createDirectories();
            SkyPaths.copyTemplateFile();
            SkyPaths.generateStarterItemsFile();
            SkyPaths.generateFeatureInformation();
            SkyPaths.generateStructureInformation();
            SkyPaths.generateBiomeInformation();
            if (server != null) {
                SkyPaths.generateDimensionInformation(server);
            }
            StartingInventory.loadStarterItems();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyTemplateFile() throws IOException {
        if (Arrays.stream(TEMPLATES_DIR.toFile().listFiles()).anyMatch(file -> file.isFile() && file.getName().endsWith(".nbt"))) {
            return;
        }
        Files.copy(SkyblockBuilder.class.getResourceAsStream("/skyblockbuilder-template.nbt"), SCHEMATIC_FILE, new CopyOption[0]);
    }

    private static void generateStarterItemsFile() throws IOException {
        if (Files.isRegularFile(ITEMS_FILE, new LinkOption[0])) {
            return;
        }
        JsonObject object = new JsonObject();
        JsonArray items = new JsonArray();
        object.add("items", (JsonElement)items);
        BufferedWriter w = Files.newBufferedWriter(ITEMS_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        w.write(SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)object));
        w.close();
    }

    public static void generateFeatureInformation() throws IOException {
        BufferedWriter w = Files.newBufferedWriter(FEATURES_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        for (Holder.Reference feature : BuiltinRegistries.f_123861_.m_203611_().toList()) {
            w.write(feature.m_205785_().m_135782_().toString() + "\n");
        }
        w.close();
    }

    public static void generateStructureInformation() throws IOException {
        BufferedWriter w = Files.newBufferedWriter(STRUCTURES_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        for (StructureFeature feature : ForgeRegistries.STRUCTURE_FEATURES.getValues()) {
            if (feature.getRegistryName() == null) continue;
            w.write(feature.getRegistryName().toString() + "\n");
        }
        w.close();
    }

    public static void generateBiomeInformation() throws IOException {
        BufferedWriter w = Files.newBufferedWriter(BIOMES_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (biome.getRegistryName() == null) continue;
            w.write(biome.getRegistryName().toString() + "\n");
        }
        w.close();
    }

    public static void generateDimensionInformation(MinecraftServer server) throws IOException {
        BufferedWriter w = Files.newBufferedWriter(DIMENSIONS_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        for (ResourceKey levelKey : server.m_129784_()) {
            w.write(levelKey.m_135782_() + "\n");
        }
        w.close();
    }
}

