/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.melanx.skyblockbuilder.ModBlockTags;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.config.SpawnSettings;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.PositionHelper;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockEndChunkGenerator;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockNoiseBasedChunkGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldUtil {
    public static void teleportToIsland(ServerPlayer player, Team team) {
        MinecraftServer server = player.m_20194_();
        ServerLevel level = WorldUtil.getConfiguredLevel(server);
        BlockPos spawn = WorldUtil.validPosition(level, team);
        player.m_8999_(level, (double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_() + 0.2, (double)spawn.m_123343_() + 0.5, (float)team.getDirection().getYRot(), 0.0f);
        player.m_9158_(level.m_46472_(), spawn, 0.0f, true, false);
    }

    public static boolean isSkyblock(Level level) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        MinecraftServer server = ((ServerLevel)level).m_142572_();
        if (!ConfigHandler.Dimensions.Overworld.Default) {
            return server.m_129783_().m_7726_().m_8481_() instanceof SkyblockNoiseBasedChunkGenerator;
        }
        if (!ConfigHandler.Dimensions.Nether.Default) {
            ServerLevel nether = server.m_129880_(Level.f_46429_);
            return nether != null && nether.m_7726_().m_8481_() instanceof SkyblockNoiseBasedChunkGenerator;
        }
        if (!ConfigHandler.Dimensions.End.Default) {
            ServerLevel end = server.m_129880_(Level.f_46430_);
            return end != null && end.m_7726_().m_8481_() instanceof SkyblockEndChunkGenerator;
        }
        return false;
    }

    public static void checkSkyblock(CommandSourceStack source) throws CommandSyntaxException {
        if (!WorldUtil.isSkyblock((Level)source.m_81377_().m_129783_())) {
            throw new SimpleCommandExceptionType((Message)new TranslatableComponent("skyblockbuilder.error.no_skyblock")).create();
        }
    }

    public static ServerLevel getConfiguredLevel(MinecraftServer server) {
        ResourceLocation location = ConfigHandler.Spawn.dimension.m_135782_();
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)location);
        ServerLevel configLevel = server.m_129880_(worldKey);
        if (configLevel == null) {
            SkyblockBuilder.getLogger().warn("Configured dimension for spawn does not exist: " + location);
        }
        return configLevel != null ? configLevel : server.m_129783_();
    }

    private static BlockPos validPosition(ServerLevel level, Team team) {
        BlockPos pos;
        ArrayList<BlockPos> spawns = new ArrayList<BlockPos>(team.getPossibleSpawns());
        Random random = new Random();
        while (!spawns.isEmpty()) {
            pos = (BlockPos)spawns.get(random.nextInt(spawns.size()));
            if (WorldUtil.isValidSpawn((Level)level, pos)) {
                return pos;
            }
            spawns.remove(pos);
        }
        pos = team.getPossibleSpawns().stream().findAny().orElse(BlockPos.f_121853_);
        return PositionHelper.findPos(pos, blockPos -> WorldUtil.isValidSpawn((Level)level, blockPos), ConfigHandler.Spawn.radius);
    }

    public static boolean isValidSpawn(Level level, BlockPos pos) {
        return WorldUtil.isValidSpawn(level, pos, level.m_141937_(), level.m_151558_());
    }

    public static boolean isValidSpawn(Level level, BlockPos pos, int bottom, int top) {
        return pos.m_123342_() >= bottom && pos.m_123342_() <= top && (level.m_8055_(pos.m_7495_()).m_60815_() || level.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.ADDITIONAL_VALID_SPAWN)) && !level.m_8055_(pos).m_60815_() && !level.m_8055_(pos.m_7494_()).m_60815_();
    }

    public static int calcSpawnHeight(Level level, int x, int z) {
        int top = ConfigHandler.Spawn.Height.range.top();
        int bottom = ConfigHandler.Spawn.Height.range.bottom();
        return Math.max(level.m_141937_() + 1, switch (ConfigHandler.Spawn.Height.spawnType) {
            case SpawnSettings.Type.RANGE_TOP, SpawnSettings.Type.RANGE_BOTTOM -> {
                BlockPos.MutableBlockPos spawn = new BlockPos.MutableBlockPos(x, top, z);
                while (!WorldUtil.isValidSpawn(level, (BlockPos)spawn, bottom, top)) {
                    if (spawn.m_123342_() <= level.m_141937_()) {
                        if (ConfigHandler.Spawn.Height.spawnType == SpawnSettings.Type.RANGE_TOP) {
                            spawn.m_142448_(top);
                            break;
                        }
                        spawn.m_142448_(bottom);
                        break;
                    }
                    spawn.m_122175_(Direction.DOWN, 1);
                }
                yield spawn.m_123342_() + ConfigHandler.Spawn.Height.offset;
            }
            default -> bottom;
        });
    }

    public static List<FlatLayerInfo> layersInfoFromString(String settings) {
        if (settings == null) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        String[] astring = settings.split(",");
        int i = 0;
        for (String s : astring) {
            FlatLayerInfo flatlayerinfo = WorldUtil.getLayerInfo(s, i);
            if (flatlayerinfo == null) {
                return Collections.emptyList();
            }
            list.add(flatlayerinfo);
            i += flatlayerinfo.m_70337_();
        }
        return list;
    }

    @Nullable
    private static FlatLayerInfo getLayerInfo(String setting, int currentLayers) {
        Block block;
        int i;
        String[] info = setting.split("\\*", 2);
        if (info.length == 2) {
            try {
                i = Math.max(Integer.parseInt(info[0]), 0);
            }
            catch (NumberFormatException numberformatexception) {
                SkyblockBuilder.getLogger().error("Error while parsing surface settings string => {}", (Object)numberformatexception.getMessage());
                return null;
            }
        } else {
            i = 1;
        }
        int maxLayers = Math.min(currentLayers + i, 384);
        int height = maxLayers - currentLayers;
        String blockName = info[info.length - 1];
        try {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        }
        catch (Exception exception) {
            SkyblockBuilder.getLogger().error("Error while parsing surface settings string => {}", (Object)exception.getMessage());
            return null;
        }
        if (block == null) {
            SkyblockBuilder.getLogger().error("Error while parsing surface settings string => Unknown block, {}", (Object)blockName);
            return null;
        }
        return new FlatLayerInfo(height, block);
    }

    public static int calculateHeightFromLayers(List<FlatLayerInfo> layerInfos) {
        int i = 0;
        for (FlatLayerInfo info : layerInfos) {
            i += info.m_70337_();
        }
        return i;
    }

    public static enum Directions {
        NORTH(180),
        EAST(270),
        SOUTH(0),
        WEST(90);

        private final int yRot;

        private Directions(int yaw) {
            this.yRot = yaw;
        }

        public int getYRot() {
            return this.yRot;
        }
    }
}

