/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world;

import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;

public final class IslandPos {
    private final int x;
    private final int z;
    private BlockPos center;

    public IslandPos(Level level, int x, int z) {
        this(x, WorldUtil.calcSpawnHeight(level, x, z), z);
    }

    public IslandPos(int x, int y, int z) {
        this.x = x;
        this.z = z;
        this.center = new BlockPos(this.x * ConfigHandler.World.islandDistance + ConfigHandler.World.offset, y, this.z * ConfigHandler.World.islandDistance + ConfigHandler.World.offset);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public void changeHeight(int y) {
        this.center = this.center.m_175288_(y);
    }

    public static IslandPos fromTag(CompoundTag tag) {
        return new IslandPos(tag.m_128451_("IslandX"), tag.m_128451_("Height"), tag.m_128451_("IslandZ"));
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("IslandX", this.x);
        tag.m_128405_("IslandZ", this.z);
        tag.m_128405_("Height", this.center.m_123342_());
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IslandPos)) {
            return false;
        }
        IslandPos islandPos = (IslandPos)o;
        return this.x == islandPos.x && this.z == islandPos.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.z;
        return result;
    }
}

