/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world;

import com.mojang.serialization.Lifecycle;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.util.BiomeSourceConverter;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockEndChunkGenerator;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockNoiseBasedChunkGenerator;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.common.world.ForgeWorldPreset;

public class VoidWorldType
extends ForgeWorldPreset {
    public VoidWorldType() {
        super(VoidWorldType::configuredOverworldChunkGenerator);
    }

    public ChunkGenerator createChunkGenerator(RegistryAccess dynamicRegistries, long seed, String generatorSettings) {
        return VoidWorldType.configuredOverworldChunkGenerator(dynamicRegistries, seed);
    }

    public WorldGenSettings createSettings(RegistryAccess dynamicRegistries, long seed, boolean generateStructures, boolean generateLoot, String generatorSettings) {
        Registry dimensionTypeRegistry = dynamicRegistries.m_175515_(Registry.f_122818_);
        Registry dimensions = WorldGenSettings.m_204649_((Registry)dimensionTypeRegistry, VoidWorldType.voidDimensions(dynamicRegistries, seed), (ChunkGenerator)this.createChunkGenerator(dynamicRegistries, seed, null));
        return new WorldGenSettings(seed, generateStructures, generateLoot, dimensions);
    }

    public static MappedRegistry<LevelStem> voidDimensions(RegistryAccess dynamicRegistries, long seed) {
        Registry noiseGeneratorSettings = dynamicRegistries.m_175515_(Registry.f_122878_);
        Registry structureSets = dynamicRegistries.m_175515_(Registry.f_211073_);
        Registry noises = dynamicRegistries.m_175515_(Registry.f_194568_);
        MappedRegistry levelStems = new MappedRegistry(Registry.f_122820_, Lifecycle.experimental(), null);
        Registry dimensionTypes = dynamicRegistries.m_175515_(Registry.f_122818_);
        Registry biomes = dynamicRegistries.m_175515_(Registry.f_122885_);
        levelStems.m_203505_(LevelStem.f_63971_, (Object)new LevelStem(dimensionTypes.m_203538_(DimensionType.f_63845_), VoidWorldType.configuredOverworldChunkGenerator(dynamicRegistries, seed)), Lifecycle.stable());
        levelStems.m_203505_(LevelStem.f_63972_, (Object)new LevelStem(dimensionTypes.m_203538_(DimensionType.f_63846_), ConfigHandler.Dimensions.Nether.Default ? VoidWorldType.defaultNetherGenerator(dynamicRegistries, seed) : VoidWorldType.netherChunkGenerator(dynamicRegistries, (Registry<StructureSet>)structureSets, (Registry<NormalNoise.NoiseParameters>)noises, (Registry<Biome>)biomes, (Registry<NoiseGeneratorSettings>)noiseGeneratorSettings, seed)), Lifecycle.stable());
        levelStems.m_203505_(LevelStem.f_63973_, (Object)new LevelStem(dimensionTypes.m_203538_(DimensionType.f_63847_), ConfigHandler.Dimensions.End.Default ? VoidWorldType.defaultEndGenerator(dynamicRegistries, seed) : VoidWorldType.endChunkGenerator(dynamicRegistries, (Registry<StructureSet>)structureSets, (Registry<NormalNoise.NoiseParameters>)noises, (Registry<Biome>)biomes, (Registry<NoiseGeneratorSettings>)noiseGeneratorSettings, seed)), Lifecycle.stable());
        return levelStems;
    }

    public static ChunkGenerator configuredOverworldChunkGenerator(RegistryAccess dynamicRegistries, long seed) {
        Registry structureSets = dynamicRegistries.m_175515_(Registry.f_211073_);
        Registry noises = dynamicRegistries.m_175515_(Registry.f_194568_);
        Registry biomes = dynamicRegistries.m_175515_(Registry.f_122885_);
        Registry noiseGeneratorSettings = dynamicRegistries.m_175515_(Registry.f_122878_);
        return ConfigHandler.Dimensions.Overworld.Default ? WorldGenSettings.m_190027_((RegistryAccess)dynamicRegistries, (long)seed) : VoidWorldType.overworldChunkGenerator(dynamicRegistries, (Registry<StructureSet>)structureSets, (Registry<NormalNoise.NoiseParameters>)noises, (Registry<Biome>)biomes, (Registry<NoiseGeneratorSettings>)noiseGeneratorSettings, seed);
    }

    public static ChunkGenerator overworldChunkGenerator(RegistryAccess dynamicRegistries, Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, @Nonnull Registry<Biome> biomeRegistry, @Nonnull Registry<NoiseGeneratorSettings> dimensionSettingsRegistry, long seed) {
        MultiNoiseBiomeSource biomeSource = (MultiNoiseBiomeSource)BiomeSourceConverter.customBiomeSource((ResourceKey<Level>)Level.f_46428_, dynamicRegistries, (BiomeSource)MultiNoiseBiomeSource.Preset.f_187087_.m_187104_(biomeRegistry, false));
        Holder settings = dimensionSettingsRegistry.m_203538_(NoiseGeneratorSettings.f_64432_);
        return new SkyblockNoiseBasedChunkGenerator(structureSets, noises, (BiomeSource)biomeSource, seed, (Holder<NoiseGeneratorSettings>)settings, (ResourceKey<Level>)Level.f_46428_);
    }

    private static ChunkGenerator defaultNetherGenerator(RegistryAccess dynamicRegistries, long seed) {
        Registry noiseGeneratorSettings = dynamicRegistries.m_175515_(Registry.f_122878_);
        Registry structureSets = dynamicRegistries.m_175515_(Registry.f_211073_);
        Registry noises = dynamicRegistries.m_175515_(Registry.f_194568_);
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.Preset.f_48512_.m_187099_(dynamicRegistries.m_175515_(Registry.f_122885_));
        Holder settings = noiseGeneratorSettings.m_203538_(NoiseGeneratorSettings.f_64434_);
        return new NoiseBasedChunkGenerator(structureSets, noises, (BiomeSource)biomeSource, seed, settings);
    }

    private static ChunkGenerator netherChunkGenerator(RegistryAccess dynamicRegistries, Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, Registry<Biome> biomeRegistry, Registry<NoiseGeneratorSettings> dimensionSettingsRegistry, long seed) {
        BiomeSource biomeSource = BiomeSourceConverter.customBiomeSource((ResourceKey<Level>)Level.f_46429_, dynamicRegistries, (BiomeSource)MultiNoiseBiomeSource.Preset.f_48512_.m_187099_(biomeRegistry));
        Holder settings = dimensionSettingsRegistry.m_203538_(NoiseGeneratorSettings.f_64434_);
        return new SkyblockNoiseBasedChunkGenerator(structureSets, noises, biomeSource, seed, (Holder<NoiseGeneratorSettings>)settings, (ResourceKey<Level>)Level.f_46429_);
    }

    private static ChunkGenerator defaultEndGenerator(RegistryAccess dynamicRegistries, long seed) {
        Registry noiseGeneratorSettings = dynamicRegistries.m_175515_(Registry.f_122878_);
        Registry structureSets = dynamicRegistries.m_175515_(Registry.f_211073_);
        Registry noises = dynamicRegistries.m_175515_(Registry.f_194568_);
        TheEndBiomeSource biomeSource = new TheEndBiomeSource(dynamicRegistries.m_175515_(Registry.f_122885_), seed);
        Holder settings = noiseGeneratorSettings.m_203538_(NoiseGeneratorSettings.f_64435_);
        return new NoiseBasedChunkGenerator(structureSets, noises, (BiomeSource)biomeSource, seed, settings);
    }

    private static ChunkGenerator endChunkGenerator(RegistryAccess dynamicRegistries, Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, Registry<Biome> biomeRegistry, Registry<NoiseGeneratorSettings> dimensionSettingsRegistry, long seed) {
        TheEndBiomeSource biomeSource = (TheEndBiomeSource)BiomeSourceConverter.customBiomeSource((ResourceKey<Level>)Level.f_46430_, dynamicRegistries, (BiomeSource)new TheEndBiomeSource(biomeRegistry, seed));
        Holder settings = dimensionSettingsRegistry.m_203538_(NoiseGeneratorSettings.f_64435_);
        return new SkyblockEndChunkGenerator(structureSets, noises, (BiomeSource)biomeSource, seed, (Holder<NoiseGeneratorSettings>)settings, (ResourceKey<Level>)Level.f_46430_);
    }
}

