/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockNoiseBasedChunkGenerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class SkyblockEndChunkGenerator
extends SkyblockNoiseBasedChunkGenerator {
    private static final int MAIN_ISLAND_DISTANCE = 16;
    public static final Codec<SkyblockEndChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> ChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and(instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(generator -> generator.f_188604_), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(generator -> generator.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(generator -> generator.f_64333_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(generator -> generator.generatorSettings), (App)Level.f_46427_.fieldOf("dimension").forGetter(generator -> generator.dimension))).apply((Applicative)instance, instance.stable(SkyblockEndChunkGenerator::new)));

    public SkyblockEndChunkGenerator(Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, long seed, Holder<NoiseGeneratorSettings> generatorSettings, ResourceKey<Level> dimension) {
        super(structureSets, noises, biomeSource, seed, generatorSettings, dimension);
    }

    @Override
    @Nonnull
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    @Override
    @Nonnull
    public ChunkGenerator m_6819_(long seed) {
        return new SkyblockEndChunkGenerator((Registry<StructureSet>)this.f_207955_, (Registry<NormalNoise.NoiseParameters>)this.f_188604_, this.f_62137_.m_7206_(seed), seed, (Holder<NoiseGeneratorSettings>)this.generatorSettings, (ResourceKey<Level>)this.dimension);
    }

    @Override
    public void m_183621_(@Nonnull WorldGenRegion level, @Nonnull StructureFeatureManager structureManager, @Nonnull ChunkAccess chunk) {
        super.m_183621_(level, structureManager, chunk);
        ChunkPos chunkPos = chunk.m_7697_();
        if (chunkPos.f_45578_ == 0 && chunkPos.f_45579_ == 0) {
            chunk.m_6978_(new BlockPos(0, 64, 0), Blocks.f_50752_.m_49966_(), false);
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<ChunkAccess> m_183489_(@Nonnull Executor executor, @Nonnull Blender blender, @Nonnull StructureFeatureManager manager, @Nonnull ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        if (ConfigHandler.Dimensions.End.mainIsland && Mth.m_14040_((int)chunkPos.f_45578_) <= 16 && Mth.m_14040_((int)chunkPos.f_45579_) <= 16) {
            return this.parent.m_183489_(executor, blender, manager, chunk);
        }
        return CompletableFuture.completedFuture(chunk);
    }

    @Override
    public void m_183516_(@Nonnull WorldGenRegion level, long seed, @Nonnull BiomeManager biomeManager, @Nonnull StructureFeatureManager structureManager, @Nonnull ChunkAccess chunk, @Nonnull GenerationStep.Carving carving) {
        ChunkPos pos = chunk.m_7697_();
        int value = 256;
        if (pos.m_45604_() <= value && pos.m_45604_() >= -value && pos.m_45605_() <= value && pos.m_45605_() >= -value) {
            super.m_183516_(level, seed, biomeManager, structureManager, chunk, carving);
        }
    }
}

