/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world.chunkgenerators;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.util.WorldUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class SkyblockNoiseBasedChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<SkyblockNoiseBasedChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> ChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and(instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(generator -> generator.f_188604_), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(generator -> generator.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(generator -> generator.f_64333_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(generator -> generator.generatorSettings), (App)Level.f_46427_.fieldOf("dimension").forGetter(generator -> generator.dimension))).apply((Applicative)instance, instance.stable(SkyblockNoiseBasedChunkGenerator::new)));
    public final long f_64333_;
    public final Registry<NormalNoise.NoiseParameters> f_188604_;
    public final Holder<NoiseGeneratorSettings> generatorSettings;
    public final ResourceKey<Level> dimension;
    protected final NoiseBasedChunkGenerator parent;
    protected final List<FlatLayerInfo> layerInfos;
    private final int layerHeight;

    public SkyblockNoiseBasedChunkGenerator(Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, long seed, Holder<NoiseGeneratorSettings> generatorSettings, ResourceKey<Level> dimension) {
        super(structureSets, noises, biomeSource, seed, generatorSettings);
        this.f_64333_ = seed;
        this.f_188604_ = noises;
        this.generatorSettings = generatorSettings;
        this.parent = new NoiseBasedChunkGenerator(structureSets, this.f_188604_, biomeSource, seed, generatorSettings);
        this.dimension = dimension;
        this.layerInfos = ConfigHandler.World.surface ? WorldUtil.layersInfoFromString(ConfigHandler.World.surfaceSettings.get(dimension.m_135782_().toString())) : Lists.newArrayList();
        this.layerHeight = WorldUtil.calculateHeightFromLayers(this.layerInfos);
    }

    @Nonnull
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public int m_6337_() {
        return ConfigHandler.World.seaHeight;
    }

    @Nonnull
    public ChunkGenerator m_6819_(long seed) {
        return new SkyblockNoiseBasedChunkGenerator((Registry<StructureSet>)this.f_207955_, this.f_188604_, this.f_62137_.m_7206_(seed), seed, this.generatorSettings, this.dimension);
    }

    public void m_183621_(@Nonnull WorldGenRegion level, @Nonnull StructureFeatureManager structureManager, @Nonnull ChunkAccess chunk) {
        if (ConfigHandler.World.surface) {
            ChunkPos cp = chunk.m_7697_();
            int xs = cp.m_45604_();
            int zs = cp.m_45605_();
            int xe = cp.m_45608_();
            int ze = cp.m_45609_();
            int y = level.m_141937_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (FlatLayerInfo info : this.layerInfos) {
                BlockState state = info.m_70344_();
                for (int i = 0; i < info.m_70337_(); ++i) {
                    for (int x = xs; x <= xe; ++x) {
                        for (int z = zs; z <= ze; ++z) {
                            pos.m_142451_(x);
                            pos.m_142448_(y);
                            pos.m_142443_(z);
                            chunk.m_6978_((BlockPos)pos, state, false);
                        }
                    }
                    ++y;
                }
            }
        }
    }

    @Nonnull
    public CompletableFuture<ChunkAccess> m_183489_(@Nonnull Executor executor, @Nonnull Blender blender, @Nonnull StructureFeatureManager manager, @Nonnull ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Nullable
    public Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> m_207970_(@Nonnull ServerLevel level, @Nonnull HolderSet<ConfiguredStructureFeature<?, ?>> structureSet, @Nonnull BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        List<Holder> holders = structureSet.m_203614_().filter(holder -> holder.m_203543_().isPresent() && ConfigHandler.Structures.generationStructures.test(((ResourceKey)holder.m_203543_().get()).m_135782_())).toList();
        HolderSet.Direct modifiedStructureSet = HolderSet.m_205800_(holders);
        for (Holder holder2 : modifiedStructureSet) {
            if (!holder2.m_203543_().isPresent() || !ConfigHandler.Structures.generationStructures.test(((ResourceKey)holder2.m_203543_().get()).m_135782_())) continue;
            return super.m_207970_(level, (HolderSet)modifiedStructureSet, pos, searchRadius, skipKnownStructures);
        }
        return null;
    }

    public int m_142647_(int x, int z, @Nonnull Heightmap.Types heightmapType, @Nonnull LevelHeightAccessor level) {
        if (ConfigHandler.World.surface) {
            return level.m_141937_() + this.layerHeight;
        }
        return this.parent.m_142647_(x, z, heightmapType, level);
    }

    public void m_183516_(@Nonnull WorldGenRegion level, long seed, @Nonnull BiomeManager biomeManager, @Nonnull StructureFeatureManager structureManager, @Nonnull ChunkAccess chunk, @Nonnull GenerationStep.Carving carving) {
    }

    protected boolean m_208016_(@Nonnull StructureSet.StructureSelectionEntry structureEntry, @Nonnull StructureFeatureManager structureManager, @Nonnull RegistryAccess registry, @Nonnull StructureManager featureManager, long seed, @Nonnull ChunkAccess chunk, @Nonnull ChunkPos chunkPos, @Nonnull SectionPos sectionPos) {
        if (structureEntry.f_210026_().m_203543_().isEmpty() || !ConfigHandler.Structures.generationStructures.test(((ResourceKey)structureEntry.f_210026_().m_203543_().get()).m_135782_())) {
            return false;
        }
        return super.m_208016_(structureEntry, structureManager, registry, featureManager, seed, chunk, chunkPos, sectionPos);
    }

    @Nonnull
    public NoiseColumn m_141914_(int posX, int posZ, @Nonnull LevelHeightAccessor level) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void m_183372_(@Nonnull WorldGenLevel level, @Nonnull ChunkAccess chunk, @Nonnull StructureFeatureManager structureFeatureManager) {
        ChunkPos chunkPos = chunk.m_7697_();
        SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)level.m_151560_());
        BlockPos blockPos = sectionPos.m_123249_();
        Registry configuredStructureFeatureRegistry = level.m_5962_().m_175515_(Registry.f_122882_);
        Map<Integer, List<ConfiguredStructureFeature>> featuresMap = configuredStructureFeatureRegistry.m_123024_().collect(Collectors.groupingBy(feature -> feature.f_65403_.m_67095_().ordinal()));
        List stepFeatureDataList = this.f_62137_.m_186733_();
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_189328_()));
        long decorationSeed = worldgenRandom.m_64690_(level.m_7328_(), blockPos.m_123341_(), blockPos.m_123343_());
        ObjectArraySet possibleBiomes = new ObjectArraySet();
        ChunkPos.m_45596_((ChunkPos)sectionPos.m_123251_(), (int)1).forEach(arg_0 -> SkyblockNoiseBasedChunkGenerator.lambda$applyBiomeDecoration$9(level, (Set)possibleBiomes, arg_0));
        possibleBiomes.retainAll(this.f_62137_.m_207840_().stream().map(Holder::m_203334_).collect(Collectors.toSet()));
        int dataSize = stepFeatureDataList.size();
        try {
            Registry placedFeatureRegistry = level.m_5962_().m_175515_(Registry.f_194567_);
            int maxDecorations = Math.max(GenerationStep.Decoration.values().length, dataSize);
            for (int i = 0; i < maxDecorations; ++i) {
                int index = 0;
                if (structureFeatureManager.m_47271_()) {
                    for (ConfiguredStructureFeature feature2 : featuresMap.getOrDefault(i, Collections.emptyList())) {
                        worldgenRandom.m_190064_(decorationSeed, index, i);
                        Supplier<String> supplier = () -> configuredStructureFeatureRegistry.m_7854_((Object)feature2).map(Object::toString).orElseGet(feature2::toString);
                        try {
                            level.m_183406_(supplier);
                            structureFeatureManager.m_207794_(sectionPos, feature2).forEach(structureStart -> structureStart.m_7129_(level, structureFeatureManager, (ChunkGenerator)this, (Random)worldgenRandom, ChunkGenerator.m_187717_((ChunkAccess)chunk), chunkPos));
                        }
                        catch (Exception exception) {
                            CrashReport report = CrashReport.m_127521_((Throwable)exception, (String)"Feature placement");
                            report.m_127514_("Feature").m_128165_("Description", supplier::get);
                            throw new ReportedException(report);
                        }
                        ++index;
                    }
                }
                if (i >= dataSize) continue;
                IntArraySet mapping = new IntArraySet();
                for (Biome biome : possibleBiomes) {
                    List holderSets = biome.m_47536_().m_47818_();
                    if (i >= holderSets.size()) continue;
                    HolderSet featureHolderSet = (HolderSet)holderSets.get(i);
                    BiomeSource.StepFeatureData stepFeatureData = (BiomeSource.StepFeatureData)stepFeatureDataList.get(i);
                    featureHolderSet.m_203614_().map(Holder::m_203334_).forEach(arg_0 -> SkyblockNoiseBasedChunkGenerator.lambda$applyBiomeDecoration$12((IntSet)mapping, stepFeatureData, arg_0));
                }
                int mappingSize = mapping.size();
                int[] array = mapping.toIntArray();
                Arrays.sort(array);
                BiomeSource.StepFeatureData stepFeatureData = (BiomeSource.StepFeatureData)stepFeatureDataList.get(i);
                for (int j = 0; j < mappingSize; ++j) {
                    int featureIndex = array[j];
                    PlacedFeature placedfeature = (PlacedFeature)stepFeatureData.f_196677_().get(featureIndex);
                    ResourceLocation registryName = ((ConfiguredFeature)placedfeature.f_191775_().m_203334_()).f_65377_().getRegistryName();
                    if (registryName != null && !ConfigHandler.Structures.generationFeatures.test(registryName)) continue;
                    Supplier<String> currentlyGenerating = () -> placedFeatureRegistry.m_7854_((Object)placedfeature).map(Object::toString).orElseGet(() -> ((PlacedFeature)placedfeature).toString());
                    worldgenRandom.m_190064_(decorationSeed, featureIndex, i);
                    try {
                        level.m_183406_(currentlyGenerating);
                        placedfeature.m_191806_(level, (ChunkGenerator)this, (Random)worldgenRandom, blockPos);
                        continue;
                    }
                    catch (Exception exception1) {
                        CrashReport report = CrashReport.m_127521_((Throwable)exception1, (String)"Feature placement");
                        report.m_127514_("Feature").m_128165_("Description", currentlyGenerating::get);
                        throw new ReportedException(report);
                    }
                }
            }
            level.m_183406_(null);
        }
        catch (Exception exception2) {
            CrashReport report = CrashReport.m_127521_((Throwable)exception2, (String)"Biome decoration");
            report.m_127514_("Generation").m_128159_("CenterX", (Object)chunkPos.f_45578_).m_128159_("CenterZ", (Object)chunkPos.f_45579_).m_128159_("Seed", (Object)decorationSeed);
            throw new ReportedException(report);
        }
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$12(IntSet mapping, BiomeSource.StepFeatureData stepFeatureData, PlacedFeature feature) {
        mapping.add(stepFeatureData.f_196678_().applyAsInt(feature));
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$9(WorldGenLevel level, Set possibleBiomes, ChunkPos pos) {
        ChunkAccess chunkAccess = level.m_6325_(pos.f_45578_, pos.f_45579_);
        for (LevelChunkSection chunkSection : chunkAccess.m_7103_()) {
            chunkSection.m_188013_().m_196879_(biomeHolder -> possibleBiomes.add((Biome)biomeHolder.m_203334_()));
        }
    }
}

