/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.mixin.client;

import dev.felnull.otyacraftengine.client.gui.subtitle.ICustomTimeSubtitle;
import dev.felnull.otyacraftengine.client.gui.subtitle.IDynamicSubtitle;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.SubtitleOverlay;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SubtitleOverlay.Subtitle.class})
public class SubtitleMixin
implements IDynamicSubtitle,
ICustomTimeSubtitle {
    private Supplier<Vec3> dynamicLocation;
    private long customTime;

    @Override
    public void setDynamicLocation(Supplier<Vec3> location) {
        this.dynamicLocation = location;
    }

    @Override
    public Supplier<Vec3> getDynamicLocation() {
        return this.dynamicLocation;
    }

    @Override
    public void setCustomTime(long time) {
        this.customTime = 3000L - time;
    }

    @Override
    public long getCustomTime() {
        return this.customTime;
    }

    @Inject(method={"getLocation"}, at={@At(value="RETURN")}, cancellable=true)
    private void getLocation(CallbackInfoReturnable<Vec3> cir) {
        Vec3 loc;
        if (this.dynamicLocation != null && (loc = this.dynamicLocation.get()) != null) {
            cir.setReturnValue((Object)loc);
        }
    }

    @Inject(method={"getTime"}, at={@At(value="RETURN")}, cancellable=true)
    private void getTime(CallbackInfoReturnable<Long> cir) {
        cir.setReturnValue((Object)((Long)cir.getReturnValue() - this.customTime));
    }
}

