/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.events;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.net.MessagePickUpVillager;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VillagerEvents {
    @SubscribeEvent
    public void onClick(PlayerInteractEvent.EntityInteract event) {
        if (!event.getWorld().f_46443_) {
            return;
        }
        if (!(event.getTarget() instanceof Villager)) {
            return;
        }
        if (!((Boolean)Main.CLIENT_CONFIG.enableRightClickPickup.get()).booleanValue()) {
            return;
        }
        Villager villager = (Villager)event.getTarget();
        Player player = event.getPlayer();
        if (!player.m_6144_()) {
            return;
        }
        if (!VillagerEvents.arePickupConditionsMet(villager)) {
            return;
        }
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePickUpVillager(villager.m_142081_()));
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Villager villager;
        if (!Main.PICKUP_KEY.m_90859_()) {
            return;
        }
        Entity pointedEntity = Minecraft.m_91087_().f_91076_;
        if (!(pointedEntity instanceof Villager) || !VillagerEvents.arePickupConditionsMet(villager = (Villager)pointedEntity)) {
            return;
        }
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePickUpVillager(villager.m_142081_()));
    }

    public static void pickUp(Villager villager, Player player) {
        if (!VillagerEvents.arePickupConditionsMet(villager)) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.VILLAGER);
        ModItems.VILLAGER.setVillager(stack, villager);
        if (player.m_21205_().m_41619_()) {
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
            villager.m_146870_();
        } else if (player.m_150109_().m_36054_(stack)) {
            villager.m_146870_();
        }
    }

    public static boolean arePickupConditionsMet(Villager villager) {
        if (!villager.m_6084_()) {
            return false;
        }
        return !villager.m_5803_();
    }
}

