/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.TileEntityFluidTank;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class RenderFluidTank
extends MekanismTileEntityRenderer<TileEntityFluidTank> {
    private static final FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterFluids = new FluidRenderMap();
    private static final FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>> cachedValveFluids = new FluidRenderMap();
    private static final int stages = 1400;

    public RenderFluidTank(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public static void resetCachedModels() {
        cachedCenterFluids.clear();
        cachedValveFluids.clear();
    }

    @Override
    protected void render(TileEntityFluidTank tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        FluidStack fluid = tile.fluidTank.getFluid();
        float fluidScale = tile.prevScale;
        VertexConsumer buffer = null;
        if (!fluid.isEmpty() && fluidScale > 0.0f) {
            int modelNumber = ModelRenderer.getStage(fluid, 1400, (double)fluidScale);
            buffer = renderer.m_6299_(Sheets.m_110792_());
            MekanismRenderer.renderObject(this.getFluidModel(fluid, modelNumber), matrix, buffer, MekanismRenderer.getColorARGB(fluid, fluidScale), MekanismRenderer.calculateGlowLight(light, fluid), overlayLight, RenderResizableCuboid.FaceDisplay.FRONT);
        }
        if (!tile.valveFluid.isEmpty() && !tile.valveFluid.getFluid().getAttributes().isGaseous(tile.valveFluid)) {
            if (buffer == null) {
                buffer = renderer.m_6299_(Sheets.m_110792_());
            }
            MekanismRenderer.renderObject(this.getValveModel(tile.valveFluid, Math.min(1399, (int)(fluidScale * 1399.0f))), matrix, buffer, MekanismRenderer.getColorARGB(tile.valveFluid), MekanismRenderer.calculateGlowLight(light, tile.valveFluid), overlayLight, RenderResizableCuboid.FaceDisplay.FRONT);
        }
    }

    @Override
    protected String getProfilerSection() {
        return "fluidTank";
    }

    private MekanismRenderer.Model3D getValveModel(@Nonnull FluidStack fluid, int stage) {
        if (cachedValveFluids.containsKey(fluid) && ((Int2ObjectMap)cachedValveFluids.get(fluid)).containsKey(stage)) {
            return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedValveFluids.get(fluid)).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        MekanismRenderer.prepFlowing(model, fluid);
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            model.minX = 0.3225f;
            model.minY = 0.0625f + 0.875f * ((float)stage / 1400.0f);
            model.minZ = 0.3225f;
            model.maxX = 0.6775f;
            model.maxY = 0.9275f;
            model.maxZ = 0.6775f;
        }
        ((Int2ObjectMap)cachedValveFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).put(stage, (Object)model);
        return model;
    }

    private MekanismRenderer.Model3D getFluidModel(@Nonnull FluidStack fluid, int stage) {
        if (cachedCenterFluids.containsKey(fluid) && ((Int2ObjectMap)cachedCenterFluids.get(fluid)).containsKey(stage)) {
            return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedCenterFluids.get(fluid)).get(stage);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            model.minX = 0.135f;
            model.minY = 0.0725f;
            model.minZ = 0.135f;
            model.maxX = 0.865f;
            model.maxY = 0.0525f + 0.875f * ((float)stage / 1400.0f);
            model.maxZ = 0.865f;
        }
        ((Int2ObjectMap)cachedCenterFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).put(stage, (Object)model);
        return model;
    }
}

