/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.container.property.list;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_client.container.property.PropertyType;
import mekanism.common.network.to_client.container.property.list.FilterListPropertyData;
import mekanism.common.network.to_client.container.property.list.FrequencyListPropertyData;
import mekanism.common.network.to_client.container.property.list.ListType;
import mekanism.common.network.to_client.container.property.list.RegistryEntryListPropertyData;
import mekanism.common.network.to_client.container.property.list.StringListPropertyData;
import net.minecraft.network.FriendlyByteBuf;

public abstract class ListPropertyData<TYPE>
extends PropertyData {
    @Nonnull
    protected final List<TYPE> values;
    private final ListType listType;

    public ListPropertyData(short property, ListType listType, @Nonnull List<TYPE> values) {
        super(PropertyType.LIST, property);
        this.listType = listType;
        this.values = values;
    }

    public static <TYPE> ListPropertyData<TYPE> readList(short property, FriendlyByteBuf buffer) {
        return switch ((ListType)buffer.m_130066_(ListType.class)) {
            default -> throw new IncompatibleClassChangeError();
            case ListType.STRING -> StringListPropertyData.read(property, arg_0 -> ((FriendlyByteBuf)buffer).m_178366_(arg_0));
            case ListType.FILTER -> FilterListPropertyData.read(property, arg_0 -> ((FriendlyByteBuf)buffer).m_178366_(arg_0));
            case ListType.FREQUENCY -> FrequencyListPropertyData.read(property, arg_0 -> ((FriendlyByteBuf)buffer).m_178366_(arg_0));
            case ListType.REGISTRY_ENTRY -> RegistryEntryListPropertyData.read(property, arg_0 -> ((FriendlyByteBuf)buffer).m_178366_(arg_0));
        };
    }

    @Override
    public void handleWindowProperty(MekanismContainer container) {
        container.handleWindowProperty(this.getProperty(), this.values);
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.m_130068_((Enum)this.listType);
        buffer.m_178352_(this.values, this::writeListElement);
    }

    protected abstract void writeListElement(FriendlyByteBuf var1, TYPE var2);

    static interface ListPropertyReader<TYPE>
    extends Function<Function<FriendlyByteBuf, TYPE>, List<TYPE>> {
    }
}

