/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Upgrade;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.inventory.slot.UpgradeInventorySlot;
import mekanism.common.recipe.upgrade.ItemRecipeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class UpgradesRecipeData
implements RecipeUpgradeData<UpgradesRecipeData> {
    private final Map<Upgrade, Integer> upgrades;
    private final List<IInventorySlot> slots;

    @Nullable
    static UpgradesRecipeData tryCreate(CompoundTag componentUpgrade) {
        if (componentUpgrade.m_128456_()) {
            return null;
        }
        Map<Upgrade, Integer> upgrades = Upgrade.buildMap(componentUpgrade);
        List<Object> slots = componentUpgrade.m_128425_("Items", 9) ? ItemRecipeData.readContents(componentUpgrade.m_128437_("Items", 10)) : Collections.emptyList();
        if (upgrades.isEmpty() && slots.isEmpty()) {
            return null;
        }
        return new UpgradesRecipeData(upgrades, slots);
    }

    private UpgradesRecipeData(Map<Upgrade, Integer> upgrades, List<IInventorySlot> slots) {
        this.upgrades = upgrades;
        this.slots = slots;
    }

    @Override
    @Nullable
    public UpgradesRecipeData merge(UpgradesRecipeData other) {
        Map<Upgrade, Integer> upgrades;
        Map<Upgrade, Integer> smallerUpgrades = other.upgrades;
        Map<Upgrade, Integer> largerUpgrades = this.upgrades;
        if (largerUpgrades.size() < smallerUpgrades.size()) {
            smallerUpgrades = this.upgrades;
            largerUpgrades = other.upgrades;
        }
        if (smallerUpgrades.isEmpty()) {
            upgrades = largerUpgrades;
        } else {
            upgrades = new EnumMap<Upgrade, Integer>(largerUpgrades);
            for (Map.Entry<Upgrade, Integer> entry : smallerUpgrades.entrySet()) {
                Upgrade upgrade = entry.getKey();
                int total = upgrades.merge(upgrade, entry.getValue(), Integer::sum);
                if (total <= upgrade.getMax()) continue;
                return null;
            }
        }
        ArrayList<IInventorySlot> allSlots = new ArrayList<IInventorySlot>(this.slots);
        allSlots.addAll(other.slots);
        return new UpgradesRecipeData(upgrades, allSlots);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.upgrades.isEmpty() && this.slots.isEmpty()) {
            return true;
        }
        AttributeUpgradeSupport upgradeSupport = Attribute.get(((BlockItem)stack.m_41720_()).m_40614_(), AttributeUpgradeSupport.class);
        if (upgradeSupport == null) {
            return false;
        }
        Set<Upgrade> supportedUpgrades = upgradeSupport.supportedUpgrades();
        if (!supportedUpgrades.containsAll(this.upgrades.keySet())) {
            return false;
        }
        List<IInventorySlot> stackSlots = List.of(UpgradeInventorySlot.input(null, supportedUpgrades), UpgradeInventorySlot.output(null));
        CompoundTag nbt = new CompoundTag();
        if (!this.upgrades.isEmpty()) {
            Upgrade.saveMap(this.upgrades, nbt);
        }
        if (ItemRecipeData.applyToStack(this.slots, stackSlots, toWrite -> nbt.m_128365_("Items", (Tag)toWrite))) {
            ItemDataUtils.setCompound(stack, "componentUpgrade", nbt);
            return true;
        }
        return false;
    }
}

