/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.text;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.MekanismClient;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class OwnerDisplay
implements IHasTextComponent {
    private final Player player;
    @Nullable
    private final UUID ownerUUID;
    @Nullable
    private final String ownerName;
    private final boolean colorBase;

    private OwnerDisplay(@Nullable Player player, @Nullable UUID ownerUUID, @Nullable String ownerName, boolean colorBase) {
        this.player = player;
        this.ownerUUID = ownerUUID;
        this.ownerName = ownerName;
        this.colorBase = colorBase;
    }

    public static OwnerDisplay of(UUID ownerUUID) {
        return OwnerDisplay.of(null, ownerUUID);
    }

    public static OwnerDisplay of(Player player, UUID ownerUUID) {
        return OwnerDisplay.of(player, ownerUUID, null);
    }

    public static OwnerDisplay of(UUID ownerUUID, String ownerName) {
        return OwnerDisplay.of(null, ownerUUID, ownerName);
    }

    public static OwnerDisplay of(Player player, UUID ownerUUID, String ownerName) {
        return OwnerDisplay.of(player, ownerUUID, ownerName, true);
    }

    public static OwnerDisplay of(Player player, UUID ownerUUID, String ownerName, boolean colorBase) {
        return new OwnerDisplay(player, ownerUUID, ownerName, colorBase);
    }

    @Override
    public Component getTextComponent() {
        if (this.ownerUUID == null) {
            return MekanismLang.NO_OWNER.translateColored(EnumColor.RED, new Object[0]);
        }
        String name = OwnerDisplay.getOwnerName(this.player, this.ownerUUID, this.ownerName);
        TranslatableComponent component = this.player == null ? MekanismLang.OWNER.translate(name) : MekanismLang.OWNER.translate(this.player.m_142081_().equals(this.ownerUUID) ? EnumColor.BRIGHT_GREEN : EnumColor.RED, name);
        if (this.colorBase) {
            return TextComponentUtil.build(EnumColor.DARK_GRAY, component);
        }
        return component;
    }

    @Nullable
    public static String getOwnerName(@Nullable Player player, @Nonnull UUID ownerUUID, @Nullable String ownerName) {
        if (ownerName != null) {
            return ownerName;
        }
        if (player != null && !player.f_19853_.f_46443_ || player == null && EffectiveSide.get().isServer()) {
            return MekanismUtils.getLastKnownUsername(ownerUUID);
        }
        Object name = MekanismClient.clientUUIDMap.get(ownerUUID);
        if (name == null && player != null) {
            if (player.m_142081_().equals(ownerUUID)) {
                name = player.m_36316_().getName();
                MekanismClient.clientUUIDMap.put(ownerUUID, (String)name);
            } else {
                Player owner = player.m_20193_().m_46003_(ownerUUID);
                if (owner == null) {
                    name = "<" + ownerUUID + ">";
                } else {
                    name = owner.m_36316_().getName();
                    MekanismClient.clientUUIDMap.put(ownerUUID, (String)name);
                }
            }
        }
        return name;
    }
}

