/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import com.mojang.authlib.GameProfile;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.net.UpdateTabNameMessage;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftbessentials.util.WarmupCooldownTeleporter;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FTBEPlayerData {
    public static final Map<UUID, FTBEPlayerData> MAP = new HashMap<UUID, FTBEPlayerData>();
    public final UUID uuid;
    public String name;
    private boolean save;
    public boolean muted;
    public boolean fly;
    public boolean god;
    public String nick;
    public TeleportPos lastSeen;
    public final LinkedHashMap<String, TeleportPos> homes;
    public int recording;
    public final WarmupCooldownTeleporter backTeleporter;
    public final WarmupCooldownTeleporter spawnTeleporter;
    public final WarmupCooldownTeleporter warpTeleporter;
    public final WarmupCooldownTeleporter homeTeleporter;
    public final WarmupCooldownTeleporter tpaTeleporter;
    public final WarmupCooldownTeleporter rtpTeleporter;
    public final LinkedList<TeleportPos> teleportHistory;

    @Nullable
    public static FTBEPlayerData get(@Nullable GameProfile profile) {
        if (profile == null || profile.getId() == null || profile.getName() == null) {
            return null;
        }
        FTBEPlayerData data = MAP.get(profile.getId());
        if (data == null) {
            data = new FTBEPlayerData(profile.getId());
            if (profile.getName() != null && !profile.getName().isEmpty()) {
                data.name = profile.getName();
            }
            MAP.put(profile.getId(), data);
        }
        return data;
    }

    @Nullable
    public static FTBEPlayerData get(Player player) {
        return PlayerHooks.isFake((Player)player) ? null : FTBEPlayerData.get(player.m_36316_());
    }

    public static void addTeleportHistory(ServerPlayer player, ResourceKey<Level> dimension, BlockPos pos) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)player);
        if (data != null) {
            data.addTeleportHistory(player, new TeleportPos(dimension, pos, Float.valueOf(player.m_146908_()), Float.valueOf(player.m_146909_())));
        }
    }

    public static void addTeleportHistory(ServerPlayer player) {
        FTBEPlayerData.addTeleportHistory(player, (ResourceKey<Level>)player.f_19853_.m_46472_(), player.m_142538_());
    }

    public FTBEPlayerData(UUID u) {
        this.uuid = u;
        this.name = "Unknown";
        this.save = false;
        this.muted = false;
        this.fly = false;
        this.god = false;
        this.nick = "";
        this.lastSeen = new TeleportPos((ResourceKey<Level>)Level.f_46428_, BlockPos.f_121853_);
        this.homes = new LinkedHashMap();
        this.recording = 0;
        this.backTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.BACK::getCooldown, FTBEConfig.BACK::getWarmup);
        this.spawnTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.SPAWN::getCooldown, FTBEConfig.SPAWN::getWarmup);
        this.warpTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.WARP::getCooldown, FTBEConfig.WARP::getWarmup);
        this.homeTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.HOME::getCooldown, FTBEConfig.HOME::getWarmup);
        this.tpaTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.TPA::getCooldown, FTBEConfig.TPA::getWarmup);
        this.rtpTeleporter = new WarmupCooldownTeleporter(this, FTBEConfig.RTP::getCooldown, FTBEConfig.RTP::getWarmup);
        this.teleportHistory = new LinkedList();
    }

    public void save() {
        this.save = true;
    }

    public SNBTCompoundTag write() {
        SNBTCompoundTag json = new SNBTCompoundTag();
        json.m_128379_("muted", this.muted);
        json.m_128379_("fly", this.fly);
        json.m_128379_("god", this.god);
        json.m_128359_("nick", this.nick);
        json.m_128359_("name", this.name);
        json.m_128365_("last_seen", (Tag)this.lastSeen.write());
        json.m_128405_("recording", this.recording);
        ListTag tph = new ListTag();
        for (TeleportPos pos : this.teleportHistory) {
            tph.add((Object)pos.write());
        }
        json.m_128365_("teleport_history", (Tag)tph);
        SNBTCompoundTag hm = new SNBTCompoundTag();
        for (Map.Entry<String, TeleportPos> h : this.homes.entrySet()) {
            hm.m_128365_(h.getKey(), (Tag)h.getValue().write());
        }
        json.m_128365_("homes", (Tag)hm);
        return json;
    }

    public void read(CompoundTag tag) {
        this.muted = tag.m_128471_("muted");
        this.fly = tag.m_128471_("fly");
        this.god = tag.m_128471_("god");
        this.nick = tag.m_128461_("nick");
        if (this.name == null) {
            this.name = tag.m_128461_("name");
        }
        this.recording = tag.m_128451_("recording");
        this.lastSeen = tag.m_128441_("last_seen") ? new TeleportPos(tag.m_128469_("last_seen")) : null;
        this.teleportHistory.clear();
        ListTag th = tag.m_128437_("teleport_history", 10);
        for (int i = 0; i < th.size(); ++i) {
            this.teleportHistory.add(new TeleportPos(th.m_128728_(i)));
        }
        this.homes.clear();
        CompoundTag h = tag.m_128469_("homes");
        for (String key : h.m_128431_()) {
            this.homes.put(key, new TeleportPos(h.m_128469_(key)));
        }
    }

    public void addTeleportHistory(ServerPlayer player, TeleportPos pos) {
        this.teleportHistory.add(pos);
        while (this.teleportHistory.size() > FTBEConfig.MAX_BACK.get(player)) {
            this.teleportHistory.removeFirst();
        }
        this.save();
    }

    public void popTeleportHistory() {
        if (!this.teleportHistory.isEmpty()) {
            this.teleportHistory.removeLast();
        } else {
            FTBEssentials.LOGGER.warn("attempted to pop empty back history for {}", (Object)this.uuid);
        }
    }

    public void load() {
        SNBTCompoundTag tag = SNBT.read((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(this.uuid + ".snbt"));
        if (tag != null) {
            this.read((CompoundTag)tag);
        }
    }

    public void saveNow() {
        if (this.save && SNBT.write((Path)FTBEWorldData.instance.mkdirs("playerdata").resolve(this.uuid + ".snbt"), (CompoundTag)this.write())) {
            this.save = false;
        }
    }

    public void sendTabName(MinecraftServer server) {
        new UpdateTabNameMessage(this.uuid, this.name, this.nick, this.recording, false).sendToAll(server);
    }

    public void sendTabName(ServerPlayer to) {
        new UpdateTabNameMessage(this.uuid, this.name, this.nick, this.recording, false).sendTo(to);
    }
}

