/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.api.common.capability.IRecipeData;
import top.theillusivec4.polymorph.common.PolymorphMod;
import top.theillusivec4.polymorph.common.capability.AbstractBlockEntityRecipeData;
import top.theillusivec4.polymorph.common.impl.RecipePair;

public abstract class AbstractRecipeData<E>
implements IRecipeData<E> {
    private final SortedSet<IRecipePair> recipesList = new TreeSet<IRecipePair>();
    private final E owner;
    private Recipe<?> lastRecipe;
    private Recipe<?> selectedRecipe;
    private ResourceLocation loadedRecipe;
    private boolean isFailing;
    private NonNullList<Item> input;

    public AbstractRecipeData(E pOwner) {
        this.owner = pOwner;
        this.input = NonNullList.m_122779_();
    }

    @Override
    public <T extends Recipe<C>, C extends Container> Optional<T> getRecipe(RecipeType<T> pType, C pInventory, Level pWorld, List<T> pRecipes) {
        List recipes;
        boolean isEmpty = this.isEmpty(pInventory);
        this.getLoadedRecipe().flatMap(id -> pWorld.m_7465_().m_44043_(id)).ifPresent(selected -> {
            try {
                if (selected.m_6671_() == pType && (selected.m_5818_(pInventory, pWorld) || isEmpty)) {
                    this.setSelectedRecipe((Recipe<?>)selected);
                }
            }
            catch (ClassCastException e) {
                PolymorphMod.LOGGER.error("Recipe {} does not match inventory {}", (Object)selected.m_6423_(), (Object)pInventory);
            }
            this.loadedRecipe = null;
        });
        if (isEmpty) {
            this.setFailing(false);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        this.getLastRecipe().ifPresent(recipe -> {
            try {
                if (recipe.m_6671_() == pType && recipe.m_5818_(pInventory, pWorld)) {
                    this.getSelectedRecipe().ifPresent(selected -> {
                        try {
                            if (selected.m_6671_() == pType && selected.m_5818_(pInventory, pWorld)) {
                                ref.set(selected);
                            }
                        }
                        catch (ClassCastException e) {
                            PolymorphMod.LOGGER.error("Recipe {} does not match inventory {}", (Object)selected.m_6423_(), (Object)pInventory);
                        }
                    });
                }
            }
            catch (ClassCastException e) {
                PolymorphMod.LOGGER.error("Recipe {} does not match inventory {}", (Object)recipe.m_6423_(), (Object)pInventory);
            }
        });
        Recipe result = ref.get();
        if (result != null && !(this instanceof AbstractBlockEntityRecipeData)) {
            boolean inputChanged = false;
            int size = pInventory.m_6643_();
            NonNullList currentInput = NonNullList.m_122780_((int)size, (Object)Items.f_41852_);
            if (size != this.input.size()) {
                inputChanged = true;
            }
            for (int i = 0; i < size; ++i) {
                ItemStack stack = pInventory.m_8020_(i);
                Item item = stack.m_41720_();
                if (!inputChanged && i < this.input.size() && item != this.input.get(i)) {
                    inputChanged = true;
                }
                if (stack.m_41619_()) continue;
                currentInput.set(i, (Object)item);
            }
            this.input = currentInput;
            if (!inputChanged) {
                this.setFailing(false);
                this.sendRecipesListToListeners(false);
                return Optional.of(result);
            }
        }
        TreeSet<IRecipePair> newDataset = new TreeSet<IRecipePair>();
        List list = recipes = pRecipes.isEmpty() ? pWorld.m_7465_().m_44056_(pType, pInventory, pWorld) : pRecipes;
        if (recipes.isEmpty()) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        ArrayList<Recipe> validRecipes = new ArrayList<Recipe>();
        for (Recipe entry : recipes) {
            ResourceLocation id2 = entry.m_6423_();
            ItemStack crafted = entry.m_5874_(pInventory);
            if (crafted.m_41619_()) continue;
            if (ref.get() == null && this.getSelectedRecipe().map(recipe -> recipe.m_6423_().equals((Object)id2)).orElse(false).booleanValue()) {
                ref.set(entry);
            }
            newDataset.add(new RecipePair(id2, crafted));
            validRecipes.add(entry);
        }
        if (validRecipes.isEmpty()) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        this.setRecipesList(newDataset);
        result = ref.get();
        if (result == null) {
            ResourceLocation rl = ((IRecipePair)newDataset.first()).getResourceLocation();
            for (Recipe recipe2 : recipes) {
                if (!recipe2.m_6423_().equals((Object)rl)) continue;
                result = recipe2;
                break;
            }
        }
        if (result == null) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        this.lastRecipe = result;
        this.setSelectedRecipe(result);
        this.setFailing(false);
        this.sendRecipesListToListeners(false);
        return Optional.of(result);
    }

    @Override
    public Optional<? extends Recipe<?>> getSelectedRecipe() {
        return Optional.ofNullable(this.selectedRecipe);
    }

    @Override
    public void setSelectedRecipe(@Nonnull Recipe<?> pRecipe) {
        this.selectedRecipe = pRecipe;
    }

    public Optional<? extends Recipe<?>> getLastRecipe() {
        return Optional.ofNullable(this.lastRecipe);
    }

    public Optional<ResourceLocation> getLoadedRecipe() {
        return Optional.ofNullable(this.loadedRecipe);
    }

    @Override
    @Nonnull
    public SortedSet<IRecipePair> getRecipesList() {
        return this.recipesList;
    }

    @Override
    public void setRecipesList(@Nonnull SortedSet<IRecipePair> pData) {
        this.recipesList.clear();
        this.recipesList.addAll(pData);
    }

    @Override
    public boolean isEmpty(Container pInventory) {
        if (pInventory != null) {
            for (int i = 0; i < pInventory.m_6643_(); ++i) {
                if (pInventory.m_8020_(i).m_41619_()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public E getOwner() {
        return this.owner;
    }

    @Override
    public void selectRecipe(@Nonnull Recipe<?> pRecipe) {
        this.setSelectedRecipe(pRecipe);
    }

    @Override
    public abstract Set<ServerPlayer> getListeners();

    @Override
    public void sendRecipesListToListeners(boolean pEmpty) {
        Pair packetData = pEmpty ? new Pair(new TreeSet(), null) : this.getPacketData();
        for (ServerPlayer listener : this.getListeners()) {
            PolymorphApi.common().getPacketDistributor().sendRecipesListS2C(listener, (SortedSet)packetData.getFirst(), (ResourceLocation)packetData.getSecond());
        }
    }

    @Override
    public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
        return new Pair(this.getRecipesList(), null);
    }

    @Override
    public boolean isFailing() {
        return this.isFailing;
    }

    @Override
    public void setFailing(boolean pFailing) {
        this.isFailing = pFailing;
    }

    @Override
    public void readNBT(CompoundTag pCompound) {
        if (pCompound.m_128441_("SelectedRecipe")) {
            this.loadedRecipe = new ResourceLocation(pCompound.m_128461_("SelectedRecipe"));
        }
        if (pCompound.m_128441_("RecipeDataSet")) {
            SortedSet<IRecipePair> dataset = this.getRecipesList();
            dataset.clear();
            ListTag list = pCompound.m_128437_("RecipeDataSet", 10);
            for (Tag inbt : list) {
                CompoundTag tag = (CompoundTag)inbt;
                ResourceLocation id = ResourceLocation.m_135820_((String)tag.m_128461_("Id"));
                ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ItemStack"));
                dataset.add(new RecipePair(id, stack));
            }
        }
    }

    @Override
    @Nonnull
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.getSelectedRecipe().ifPresent(selected -> nbt.m_128359_("SelectedRecipe", this.selectedRecipe.m_6423_().toString()));
        SortedSet<IRecipePair> dataset = this.getRecipesList();
        if (!dataset.isEmpty()) {
            ListTag list = new ListTag();
            for (IRecipePair data : dataset) {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("ItemStack", (Tag)data.getOutput().m_41739_(new CompoundTag()));
                tag.m_128359_("Id", data.getResourceLocation().toString());
                list.add((Object)tag);
            }
            nbt.m_128365_("RecipeDataSet", (Tag)list);
        }
        return nbt;
    }
}

