/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.blockEntity;

import cc.tweaked_programs.cccbridge.CCCRegister;
import cc.tweaked_programs.cccbridge.blockEntity.PeripheralBlockEntity;
import cc.tweaked_programs.cccbridge.peripherals.TargetBlockPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TargetBlockEntity
extends BlockEntity
implements PeripheralBlockEntity {
    private TargetBlockPeripheral peripheral;

    public TargetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CCCRegister.TARGET_BLOCK_ENTITY.get(), pos, state);
    }

    public void updateContent(int offset, List<String> content) {
        if (this.peripheral == null) {
            return;
        }
        int height = this.getHeight();
        int i = 0;
        for (String line : content) {
            if (i < height) {
                this.peripheral.replaceLine(offset + i, line);
            }
            ++i;
        }
    }

    @Override
    public IPeripheral getPeripheral(@NotNull Direction side) {
        if (this.peripheral == null) {
            this.peripheral = new TargetBlockPeripheral(this);
        }
        return this.peripheral;
    }

    public int getWidth() {
        if (this.peripheral == null) {
            return 1;
        }
        return this.peripheral.getWidth();
    }

    public int getHeight() {
        if (this.peripheral == null) {
            return 1;
        }
        return this.peripheral.getHeight();
    }
}

