/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.spawner;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.spawner.SpawnerConditions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnerRule {
    private final List<EntityType<?>> mobs = new ArrayList();
    private final List<Float> weights = new ArrayList<Float>();
    private final List<String> scoreboardTags = new ArrayList<String>();
    private final MobCategory mobsFromBiome;
    private final float maxWeight;
    private final float persecond;
    private final int attempts;
    private final int minSpawn;
    private final int maxSpawn;
    private final int groupDistance;
    private final Set<String> phases;
    private final SpawnerConditions conditions;
    private static final Map<String, Cmd> COMMANDS = new HashMap<String, Cmd>();

    private SpawnerRule(Builder builder) {
        this.mobs.addAll(builder.mobs);
        this.weights.addAll(builder.weights);
        this.scoreboardTags.addAll(builder.scoreboardTags);
        this.mobsFromBiome = builder.mobsFromBiome;
        this.phases = builder.phases;
        this.persecond = builder.persecond;
        this.attempts = builder.attempts;
        this.conditions = builder.conditions;
        this.minSpawn = builder.minSpawn;
        this.maxSpawn = builder.maxSpawn;
        this.groupDistance = builder.groupDistance;
        float w = 0.0f;
        for (Float weight : this.weights) {
            w += weight.floatValue();
        }
        if (w <= 0.0f) {
            w = this.mobs.size();
        }
        this.maxWeight = w;
    }

    public List<EntityType<?>> getMobs() {
        return this.mobs;
    }

    public List<String> getScoreboardTags() {
        return this.scoreboardTags;
    }

    public List<Float> getWeights() {
        return this.weights;
    }

    public MobCategory getMobsFromBiome() {
        return this.mobsFromBiome;
    }

    public float getMaxWeight() {
        return this.maxWeight;
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public float getPersecond() {
        return this.persecond;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int getMinSpawn() {
        return this.minSpawn;
    }

    public int getMaxSpawn() {
        return this.maxSpawn;
    }

    public int getGroupDistance() {
        return this.groupDistance;
    }

    public SpawnerConditions getConditions() {
        return this.conditions;
    }

    public static Builder create() {
        return new Builder();
    }

    public static void parse(JsonObject object, Builder builder) {
        block11: for (String attr : object.keySet()) {
            Cmd cmd = COMMANDS.get(attr);
            if (cmd == null) {
                ErrorHandler.error("Invalid command '" + attr + "' for spawner rule!");
                return;
            }
            switch (cmd) {
                case MOB: {
                    JsonElement mob = object.get("mob");
                    if (mob.isJsonArray()) {
                        for (JsonElement element : mob.getAsJsonArray()) {
                            SpawnerRule.addMob(builder, element);
                        }
                        continue block11;
                    }
                    SpawnerRule.addMob(builder, mob);
                    break;
                }
                case WEIGHTS: {
                    JsonElement weights = object.get("weights");
                    if (weights.isJsonArray()) {
                        for (JsonElement element : weights.getAsJsonArray()) {
                            builder.weights(Float.valueOf(element.getAsFloat()));
                        }
                        continue block11;
                    }
                    builder.weights(Float.valueOf(weights.getAsFloat()));
                    break;
                }
                case MOBSFROMBIOME: {
                    if (!builder.mobs.isEmpty()) {
                        InControl.setup.getLogger().error("'mobsfrombiome' cannot be combined with manual mobs!");
                        throw new RuntimeException("'mobsfrombiome' cannot be combined with manual mobs!");
                    }
                    String name = object.get("mobsfrombiome").getAsString().toLowerCase();
                    Iterator classification = MobCategory.m_21605_((String)name);
                    if (classification == null) {
                        InControl.setup.getLogger().error("Unknown classification " + name + "!");
                        throw new RuntimeException("Unknown classification " + name + "!");
                    }
                    builder.mobsFromBiome((MobCategory)classification);
                    break;
                }
                case PHASE: {
                    JsonElement phaseElement = object.get("phase");
                    if (phaseElement.isJsonArray()) {
                        for (JsonElement element : phaseElement.getAsJsonArray()) {
                            builder.phases(element.getAsString());
                        }
                        continue block11;
                    }
                    builder.phases(phaseElement.getAsString());
                    break;
                }
                case PERSECOND: {
                    builder.perSecond(object.getAsJsonPrimitive("persecond").getAsFloat());
                    break;
                }
                case ATTEMPTS: {
                    builder.attempts(object.getAsJsonPrimitive("attempts").getAsInt());
                    break;
                }
                case ADDSCOREBOARDTAGS: {
                    JsonElement tags = object.get("addscoreboardtags");
                    if (tags.isJsonArray()) {
                        for (JsonElement element : tags.getAsJsonArray()) {
                            builder.addScoreboardTags(element.getAsString());
                        }
                        continue block11;
                    }
                    builder.addScoreboardTags(tags.getAsString());
                    break;
                }
                case AMOUNT: {
                    JsonObject amount = object.getAsJsonObject("amount");
                    if (amount.has("minimum")) {
                        builder.minSpawn(amount.getAsJsonPrimitive("minimum").getAsInt());
                    }
                    if (amount.has("maximum")) {
                        builder.maxSpawn(amount.getAsJsonPrimitive("maximum").getAsInt());
                    }
                    if (!amount.has("groupdistance")) continue block11;
                    builder.groupDistance(amount.getAsJsonPrimitive("groupdistance").getAsInt());
                    break;
                }
                case CONDITIONS: {
                    JsonObject conditions = object.getAsJsonObject("conditions");
                    SpawnerConditions.Builder conditionsBuilder = SpawnerConditions.create();
                    SpawnerConditions.parse(conditions, conditionsBuilder);
                    SpawnerConditions cnd = conditionsBuilder.build();
                    cnd.validate();
                    builder.conditions(cnd);
                }
            }
        }
    }

    private static void addMob(Builder builder, JsonElement element) {
        EntityType value = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(element.getAsString()));
        if (value == null) {
            InControl.setup.getLogger().error("Error finding entity " + element.getAsString() + "!");
            throw new RuntimeException("Error finding entity " + element.getAsString() + "!");
        }
        builder.mobs(value);
    }

    static {
        for (Cmd cmd : Cmd.values()) {
            COMMANDS.put(cmd.name().toLowerCase(), cmd);
        }
    }

    public static class Builder {
        private final List<EntityType<?>> mobs = new ArrayList();
        private final List<Float> weights = new ArrayList<Float>();
        private final List<String> scoreboardTags = new ArrayList<String>();
        private MobCategory mobsFromBiome = null;
        private final Set<String> phases = new HashSet<String>();
        private float persecond = 1.0f;
        private int attempts = 1;
        private int minSpawn = 1;
        private int maxSpawn = 1;
        private int groupDistance = -1;
        private SpawnerConditions conditions = SpawnerConditions.DEFAULT;

        public Builder mobs(EntityType<?> ... mobs) {
            Collections.addAll(this.mobs, mobs);
            return this;
        }

        public Builder addScoreboardTags(String ... tags) {
            Collections.addAll(this.scoreboardTags, tags);
            return this;
        }

        public Builder weights(Float ... weights) {
            Collections.addAll(this.weights, weights);
            return this;
        }

        public Builder mobsFromBiome(MobCategory mobsFromBiome) {
            this.mobsFromBiome = mobsFromBiome;
            return this;
        }

        public Builder phases(String ... phases) {
            Collections.addAll(this.phases, phases);
            return this;
        }

        public Builder perSecond(float persecond) {
            this.persecond = persecond;
            return this;
        }

        public Builder attempts(int attempts) {
            this.attempts = attempts;
            return this;
        }

        public Builder minSpawn(int minSpawn) {
            this.minSpawn = minSpawn;
            return this;
        }

        public Builder maxSpawn(int maxSpawn) {
            this.maxSpawn = maxSpawn;
            return this;
        }

        public Builder groupDistance(int groupDistance) {
            this.groupDistance = groupDistance;
            return this;
        }

        public Builder conditions(SpawnerConditions conditions) {
            this.conditions = conditions;
            return this;
        }

        public SpawnerRule build() {
            return new SpawnerRule(this);
        }
    }

    static enum Cmd {
        MOB,
        WEIGHTS,
        MOBSFROMBIOME,
        PHASE,
        PERSECOND,
        ATTEMPTS,
        ADDSCOREBOARDTAGS,
        AMOUNT,
        CONDITIONS;

    }
}

