/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.cache;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.Map;
import mcjty.incontrol.tools.cache.StructureCacheEntry;
import mcjty.incontrol.tools.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;

public class StructureCache {
    public static final StructureCache CACHE = new StructureCache();
    private final Map<StructureCacheEntry, Boolean> structureCache = new HashMap<StructureCacheEntry, Boolean>();

    public void clean() {
        this.structureCache.clear();
    }

    public boolean isInStructure(LevelAccessor world, String structure, BlockPos pos) {
        ResourceKey<Level> dimension = Tools.getDimensionKey(world);
        ChunkPos cp = new ChunkPos(pos);
        long cplong = ChunkPos.m_45589_((int)cp.f_45578_, (int)cp.f_45579_);
        StructureCacheEntry entry = new StructureCacheEntry(structure, dimension, cplong);
        if (this.structureCache.containsKey(entry)) {
            return this.structureCache.get(entry);
        }
        ServerLevel sw = Tools.getServerWorld(world);
        ChunkAccess chunk = sw.m_6522_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62316_, false);
        if (chunk == null) {
            return false;
        }
        Map references = chunk.m_7049_();
        for (Map.Entry e : references.entrySet()) {
            LongSet longs = (LongSet)e.getValue();
            if (longs.isEmpty()) continue;
            this.structureCache.put(new StructureCacheEntry(((ConfiguredStructureFeature)e.getKey()).f_65403_.getRegistryName().toString(), dimension, cplong), true);
        }
        if (this.structureCache.containsKey(entry)) {
            return true;
        }
        this.structureCache.put(entry, false);
        return false;
    }
}

