/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.serversync.networking;

import iskallia.vault.config.Config;
import iskallia.vault.init.ModConfigs;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lv.id.bonne.vaulthunters.serversync.ServerConfigSyncMod;
import lv.id.bonne.vaulthunters.serversync.utils.Compress;
import lv.id.bonne.vaulthunters.serversync.utils.IConfigReadFromString;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class GenericConfigSyncDescriptor {
    public static final BiConsumer<GenericConfigSyncDescriptor, FriendlyByteBuf> ENCODER = (message, buffer) -> buffer.m_130087_(Compress.compressString(message.configContent)).m_130070_(message.configName).m_130070_(message.parameter);
    public static final Function<FriendlyByteBuf, GenericConfigSyncDescriptor> DECODER = buffer -> new GenericConfigSyncDescriptor(Compress.decompress(buffer.m_130052_()), buffer.m_130277_(), buffer.m_130277_());
    public static final BiConsumer<GenericConfigSyncDescriptor, Supplier<NetworkEvent.Context>> CONSUMER = (message, context) -> {
        ServerConfigSyncMod.LOGGER.info("Pocket received. Start handling.");
        NetworkEvent.Context cont = (NetworkEvent.Context)context.get();
        message.handle(cont);
    };
    private final String configContent;
    private final String configName;
    private final String parameter;

    public GenericConfigSyncDescriptor(String configContent, String configName, String parameter) {
        this.configContent = configContent;
        this.configName = configName;
        this.parameter = parameter;
    }

    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerConfigSyncMod.LOGGER.info("Start processing config: " + this.configName);
            try {
                Field field = ModConfigs.class.getField(this.configName);
                Object object = field.get(ModConfigs.class);
                if (object instanceof Config) {
                    Object config = (Config)object;
                    ModConfigs.CONFIGS.remove(config);
                    config = ((IConfigReadFromString)config).decodeFromJson(this.configContent);
                    field.set(ModConfigs.class, config);
                    ModConfigs.CONFIGS.add(config);
                    ServerConfigSyncMod.LOGGER.info("Config Updated!");
                } else if (object instanceof Map) {
                    Map map = (Map)object;
                    Optional<Object> optionalKey = map.keySet().stream().filter(key -> key.toString().equals(this.parameter)).findFirst();
                    optionalKey.ifPresent(key -> {
                        Object configValue = (Config)map.get(key);
                        ModConfigs.CONFIGS.remove(configValue);
                        configValue = ((IConfigReadFromString)configValue).decodeFromJson(this.configContent);
                        map.replace(key, configValue);
                        ModConfigs.CONFIGS.add(configValue);
                        ServerConfigSyncMod.LOGGER.info("Config Updated!");
                    });
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                ServerConfigSyncMod.LOGGER.error("Error while reading config: " + this.configName, (Throwable)e);
            }
        });
        context.setPacketHandled(true);
    }
}

