/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.vaulthunters.serversync.utils;

import iskallia.vault.config.Config;
import iskallia.vault.init.ModConfigs;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lv.id.bonne.vaulthunters.serversync.ServerConfigSyncMod;
import lv.id.bonne.vaulthunters.serversync.networking.GenericConfigSyncDescriptor;
import lv.id.bonne.vaulthunters.serversync.networking.ServerConfigSyncNetwork;
import lv.id.bonne.vaulthunters.serversync.utils.IConfigReadFromString;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public class ConfigHelper {
    public static final Map<String, String> CONFIG_MAP = new HashMap<String, String>();

    public static void registerConfigs() {
        CONFIG_MAP.clear();
        for (Field field : ModConfigs.class.getDeclaredFields()) {
            try {
                Object fieldObject = field.get(ModConfigs.class);
                if (fieldObject instanceof Config) {
                    Config config = (Config)fieldObject;
                    CONFIG_MAP.put(config.getName(), field.getName());
                    continue;
                }
                if (!(fieldObject instanceof Map)) continue;
                Map map = (Map)fieldObject;
                for (Object key : map.keySet()) {
                    Config configValue = (Config)map.get(key);
                    CONFIG_MAP.put(configValue.getName(), field.getName());
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void syncServerConfigs(ServerPlayer player) {
        ServerConfigSyncMod.LOGGER.info("Preparing to send configs to player: " + player.m_7755_().getString());
        ((List)ServerConfigSyncMod.CONFIGURATION.getListSyncConfigs().get()).forEach(configLocation -> {
            try {
                String corrected = (File.separator.equals("\\") ? configLocation.replaceAll("/", "\\\\") : configLocation).replaceAll("\\\\", "/").replace(".json", "");
                String configField = CONFIG_MAP.get(corrected);
                if (configField == null) {
                    ServerConfigSyncMod.LOGGER.error("Error, could not find config with name: " + configLocation);
                    return;
                }
                Field field = ModConfigs.class.getField(configField);
                Object fieldObject = field.get(ModConfigs.class);
                if (fieldObject instanceof Config) {
                    Config config = (Config)fieldObject;
                    ServerConfigSyncMod.LOGGER.info("Sending updated config file: " + configLocation);
                    ServerConfigSyncNetwork.syncServerConfig(new GenericConfigSyncDescriptor(((IConfigReadFromString)config).encodeToJson(config), configField, ""), player);
                } else if (fieldObject instanceof Map) {
                    Map map = (Map)fieldObject;
                    map.entrySet().stream().filter(entry -> ((Config)entry.getValue()).getName().equals(corrected)).findFirst().ifPresent(entry -> {
                        ServerConfigSyncMod.LOGGER.info("Sending updated config file: " + configLocation);
                        ServerConfigSyncNetwork.syncServerConfig(new GenericConfigSyncDescriptor(((IConfigReadFromString)entry.getValue()).encodeToJson((Config)entry.getValue()), configField, entry.getKey().toString()), player);
                    });
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                ServerConfigSyncMod.LOGGER.error("Error while preparing to send config: " + configLocation, (Throwable)e);
            }
        });
        player.m_9146_((Component)new TextComponent("Client synchronized with server configs.").m_130940_(ChatFormatting.GRAY), ChatType.SYSTEM, Util.f_137441_);
    }
}

