/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility;

import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import mcjty.rftoolsutility.apiimpl.teleportation.TeleportationManager;
import mcjty.rftoolsutility.modules.crafter.CrafterModule;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.ScreenModuleRegistry;
import mcjty.rftoolsutility.modules.spawner.SpawnerModule;
import mcjty.rftoolsutility.modules.tank.TankModule;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.setup.ClientSetup;
import mcjty.rftoolsutility.setup.Config;
import mcjty.rftoolsutility.setup.ModSetup;
import mcjty.rftoolsutility.setup.Registration;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="rftoolsutility")
public class RFToolsUtility {
    public static final String MODID = "rftoolsutility";
    public static final ModSetup setup = new ModSetup();
    public static RFToolsUtility instance;
    private final Modules modules = new Modules();
    public static final ScreenModuleRegistry screenModuleRegistry;

    public RFToolsUtility() {
        instance = this;
        this.setupModules();
        Config.register(this.modules);
        Registration.register();
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.addListener(setup::init);
        modbus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        modbus.addListener(this::processIMC);
        modbus.addListener(setup::registerCapabilities);
        modbus.addGenericListener(EntityType.class, this::onRegister);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modbus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
            modbus.addListener(ClientSetup::onTextureStitch);
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::renderGameOverlayEvent);
        });
    }

    public void onRegister(RegistryEvent.Register<EntityType<?>> e) {
        SpawnerModule.SPAWNER_RECIPE_TYPE.register();
        EnvironmentalModule.SYRINGE_RECIPE_TYPE.register();
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getTeleportationManager".equals(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(new TeleportationManager());
            } else if ("getScreenModuleRegistry".equalsIgnoreCase(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(screenModuleRegistry);
            }
        });
    }

    private void setupModules() {
        this.modules.register((IModule)new CrafterModule());
        this.modules.register((IModule)new LogicBlockModule());
        this.modules.register((IModule)new ScreenModule());
        this.modules.register((IModule)new SpawnerModule());
        this.modules.register((IModule)new TankModule());
        this.modules.register((IModule)new TeleporterModule());
        this.modules.register((IModule)new EnvironmentalModule());
    }

    static {
        screenModuleRegistry = new ScreenModuleRegistry();
    }
}

