/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class TeleportDestination {
    private final BlockPos coordinate;
    private final ResourceKey<Level> dimension;
    private String name = "";
    private boolean privateAccess = false;
    private Set<String> allowedPlayers = null;

    public TeleportDestination(FriendlyByteBuf buf) {
        int cx = buf.readInt();
        int cy = buf.readInt();
        int cz = buf.readInt();
        this.coordinate = cx == -1 && cy == -1 && cz == -1 ? null : new BlockPos(cx, cy, cz);
        this.dimension = LevelTools.getId((ResourceLocation)buf.m_130281_());
        this.setName(buf.m_130136_(Short.MAX_VALUE));
        this.privateAccess = buf.readBoolean();
        int len = buf.readInt();
        if (len == -1) {
            this.allowedPlayers = null;
        } else {
            this.allowedPlayers = new HashSet<String>(len);
            for (int i = 0; i < len; ++i) {
                this.allowedPlayers.add(buf.m_130136_(Short.MAX_VALUE));
            }
        }
    }

    public TeleportDestination(CompoundTag tc) {
        this.coordinate = new BlockPos(tc.m_128451_("x"), tc.m_128451_("y"), tc.m_128451_("z"));
        this.dimension = LevelTools.getId((String)tc.m_128461_("dim"));
        this.name = tc.m_128461_("name");
        this.privateAccess = tc.m_128471_("privateAccess");
        if (tc.m_128441_("allowedPlayers")) {
            ListTag players = tc.m_128437_("allowedPlayers", 8);
            this.allowedPlayers = new HashSet<String>(players.size());
            players.forEach(player -> this.allowedPlayers.add(player.m_7916_()));
        } else {
            this.allowedPlayers = null;
        }
    }

    public TeleportDestination(BlockPos coordinate, ResourceKey<Level> dimension) {
        this.coordinate = coordinate;
        this.dimension = dimension;
    }

    public boolean isValid() {
        return this.coordinate != null;
    }

    public CompoundTag writeToTag() {
        CompoundTag tc = new CompoundTag();
        BlockPos c = this.getCoordinate();
        tc.m_128405_("x", c.m_123341_());
        tc.m_128405_("y", c.m_123342_());
        tc.m_128405_("z", c.m_123343_());
        tc.m_128359_("dim", this.getDimension().m_135782_().toString());
        tc.m_128359_("name", this.getName());
        tc.m_128379_("privateAccess", this.privateAccess);
        if (this.allowedPlayers != null) {
            ListTag list = new ListTag();
            this.allowedPlayers.forEach(p -> list.add((Object)StringTag.m_129297_((String)p)));
            tc.m_128365_("allowedPlayers", (Tag)list);
        }
        return tc;
    }

    public void toBytes(FriendlyByteBuf buf) {
        if (this.coordinate == null) {
            buf.writeInt(-1);
            buf.writeInt(-1);
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.coordinate.m_123341_());
            buf.writeInt(this.coordinate.m_123342_());
            buf.writeInt(this.coordinate.m_123343_());
        }
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130070_(this.getName());
        buf.writeBoolean(this.privateAccess);
        if (this.allowedPlayers == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.allowedPlayers.size());
            this.allowedPlayers.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    @Nullable
    public Set<String> getAllowedPlayers() {
        return this.allowedPlayers;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
    }

    public boolean isAccessKnown() {
        return this.allowedPlayers != null;
    }

    public boolean checkAccess(Level level, UUID player) {
        if (!this.privateAccess) {
            return true;
        }
        ServerPlayer playerByUuid = level.m_142572_().m_6846_().m_11259_(player);
        if (playerByUuid == null) {
            return true;
        }
        return this.allowedPlayers.contains(playerByUuid.m_5446_().getString());
    }

    public void setAllowedPlayers(@Nullable Set<String> allowedPlayers) {
        this.allowedPlayers = allowedPlayers == null ? null : new HashSet<String>(allowedPlayers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeleportDestination that = (TeleportDestination)o;
        return Objects.equals(this.coordinate, that.coordinate) && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.coordinate, this.dimension, this.name);
    }
}

