/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.items.porter;

import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.various.IItemCycler;
import mcjty.rftoolsutility.modules.teleporter.PorterTools;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.client.GuiAdvancedPorter;
import mcjty.rftoolsutility.modules.teleporter.items.porter.ChargedPorterItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AdvancedChargedPorterItem
extends ChargedPorterItem
implements IItemCycler {
    public static final int MAXTARGETS = 8;

    public AdvancedChargedPorterItem() {
        super((Integer)TeleportConfiguration.ADVANCED_CHARGEDPORTER_MAXENERGY.get());
    }

    public void cycle(Player player, ItemStack stack, boolean next) {
        PorterTools.cycleDestination(player, next, stack);
    }

    @Override
    protected int getSpeedBonus() {
        return (Integer)TeleportConfiguration.advancedSpeedBonus.get();
    }

    @Override
    protected void selectOnReceiver(Player player, Level world, CompoundTag tagCompound, int id) {
        int i;
        for (i = 0; i < 8; ++i) {
            if (!tagCompound.m_128441_("target" + i) || tagCompound.m_128451_("target" + i) != id) continue;
            Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Receiver " + id + " was already added to the charged porter."));
            return;
        }
        for (i = 0; i < 8; ++i) {
            if (tagCompound.m_128441_("target" + i)) continue;
            tagCompound.m_128405_("target" + i, id);
            Logging.message((Player)player, (String)("Receiver " + id + " is added to the charged porter."));
            if (!tagCompound.m_128441_("target")) {
                tagCompound.m_128405_("target", id);
            }
            return;
        }
        Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Charged porter has no free targets!"));
    }

    @Override
    protected void selectReceiver(ItemStack stack, Level world, Player player) {
        if (world.f_46443_) {
            GuiAdvancedPorter.open();
        }
    }

    @Override
    protected void selectOnThinAir(Player player, Level world, CompoundTag tagCompound, ItemStack stack) {
        this.selectReceiver(stack, world, player);
    }
}

