/*
 * Decompiled with CFR 0.152.
 */
package com.radimous.vaultcuriosenhancements;

import com.radimous.vaultcuriosenhancements.CommonEvent;
import com.radimous.vaultcuriosenhancements.Config;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypeMessage;

@Mod(value="vault_curios_enhancements")
public class VaultCuriosEnhancements {
    public static final String MODID = "vault_curios_enhancements";

    public VaultCuriosEnhancements() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        MinecraftForge.EVENT_BUS.register((Object)new CommonEvent());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("shard_pouch").icon(new ResourceLocation("curios:slot/shard_pouch")).priority(800).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("coin_pouch").icon(new ResourceLocation("curios:slot/coin_pouch")).priority(800).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("antique_collector_book").icon(new ResourceLocation("curios:slot/antique_collector_book")).priority(800).build());
    }

    public static String fmtNum(int num) {
        if (num >= 1000000000) {
            return String.format("%.1fB", (double)num / 1.0E9);
        }
        if (num >= 100000000) {
            return String.format("%.0fM", (double)num / 1000000.0);
        }
        if (num >= 1000000) {
            return String.format("%.1fM", (double)num / 1000000.0);
        }
        if (num >= 100000) {
            return String.format("%.0fK", (double)num / 1000.0);
        }
        if (num >= 10000) {
            return String.format("%.1fK", (double)num / 1000.0);
        }
        if (num >= 1000) {
            return String.format("%.2fK", (double)num / 1000.0);
        }
        return String.valueOf(num);
    }

    public static int getFirstItemIndex(ServerPlayer player, Item item) {
        SlotResult shardPouchSlot = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, item).orElse(null);
        if (shardPouchSlot != null) {
            return -1;
        }
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41619_() || !stack.m_150930_(item)) continue;
            return i;
        }
        return -2;
    }
}

