/*
 * Decompiled with CFR 0.152.
 */
package com.radimous.vaultcuriosenhancements.mixin;

import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemShardPouch;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@Debug(export=true)
@Mixin(value={ItemShardPouch.class}, remap=false)
public class ItemShardPouchMixin {
    @ModifyVariable(method={"getShardCount(Lnet/minecraft/world/entity/player/Inventory;)I"}, at=@At(value="STORE", ordinal=0), ordinal=0)
    private static int getShardCount(int original, Inventory inventory) {
        ItemStack stack = ItemStack.f_41583_;
        Optional slot = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)inventory.f_35978_, (Item)ModItems.SHARD_POUCH);
        if (slot.isPresent()) {
            stack = ((SlotResult)slot.get()).stack();
        }
        if (stack.m_41619_()) {
            return original;
        }
        return ItemShardPouch.getContainedStack((ItemStack)stack).m_41613_();
    }

    @ModifyVariable(method={"reduceShardAmount"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private static int reduceShardAmount(int value, Inventory inventory, int count, boolean simulate) {
        ItemStack stack = ItemStack.f_41583_;
        Optional slot = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)inventory.f_35978_, (Item)ModItems.SHARD_POUCH);
        if (slot.isPresent()) {
            stack = ((SlotResult)slot.get()).stack();
        }
        if (stack.m_41619_()) {
            return count;
        }
        ItemStack shardStack = ItemShardPouch.getContainedStack((ItemStack)stack);
        int toReduce = Math.min(count, shardStack.m_41613_());
        if (!simulate) {
            shardStack.m_41764_(shardStack.m_41613_() - toReduce);
            ItemShardPouch.setContainedStack((ItemStack)stack, (ItemStack)shardStack);
        }
        return Math.max(count -= toReduce, 0);
    }
}

