/*
 * Decompiled with CFR 0.152.
 */
package com.radimous.vaultcuriosenhancements.network;

import com.radimous.vaultcuriosenhancements.VaultCuriosEnhancements;
import iskallia.vault.container.inventory.ShardPouchContainer;
import iskallia.vault.init.ModItems;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class C2SOpenShardPouchPacket {
    public static void encode(C2SOpenShardPouchPacket msg, FriendlyByteBuf packetBuffer) {
    }

    public static C2SOpenShardPouchPacket decode(FriendlyByteBuf packetBuffer) {
        return new C2SOpenShardPouchPacket();
    }

    public static void handle(C2SOpenShardPouchPacket pkt, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender != null) {
                final int index = VaultCuriosEnhancements.getFirstItemIndex(sender, (Item)ModItems.SHARD_POUCH);
                if (index == -2) {
                    sender.m_5661_((Component)new TextComponent("You don't have a Shard Pouch in your inventory!"), true);
                    return;
                }
                NetworkHooks.openGui((ServerPlayer)sender, (MenuProvider)new MenuProvider(){

                    @NotNull
                    public Component m_5446_() {
                        return new TextComponent("Shard Pouch");
                    }

                    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                        return new ShardPouchContainer(windowId, inventory, index);
                    }
                }, buf -> buf.writeInt(index));
            }
        });
        context.setPacketHandled(true);
    }
}

