/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client.gui;

import com.buuz135.functionalstorage.fluid.BigFluidHandler;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidDrawerInfoGuiAddon
extends BasicScreenAddon {
    private final ResourceLocation gui;
    private final int slotAmount;
    private final Function<Integer, Pair<Integer, Integer>> slotPosition;
    private final Supplier<BigFluidHandler> fluidHandlerSupplier;
    private final Function<Integer, Integer> slotMaxAmount;

    public FluidDrawerInfoGuiAddon(int posX, int posY, ResourceLocation gui, int slotAmount, Function<Integer, Pair<Integer, Integer>> slotPosition, Supplier<BigFluidHandler> fluidHandlerSupplier, Function<Integer, Integer> slotMaxAmount) {
        super(posX, posY);
        this.gui = gui;
        this.slotAmount = slotAmount;
        this.slotPosition = slotPosition;
        this.fluidHandlerSupplier = fluidHandlerSupplier;
        this.slotMaxAmount = slotMaxAmount;
    }

    public static Rect2i getSizeForSlots(int currentSlot, int slotAmount) {
        if (slotAmount == 1) {
            return new Rect2i(9, 9, 30, 30);
        }
        if (slotAmount == 2) {
            if (currentSlot == 0) {
                return new Rect2i(0, 30, 48, 13);
            }
            if (currentSlot == 1) {
                return new Rect2i(0, 6, 48, 13);
            }
        }
        if (slotAmount == 4) {
            if (currentSlot == 0) {
                return new Rect2i(30, 30, 16, 16);
            }
            if (currentSlot == 1) {
                return new Rect2i(2, 30, 16, 16);
            }
            if (currentSlot == 2) {
                return new Rect2i(30, 2, 16, 16);
            }
            if (currentSlot == 3) {
                return new Rect2i(2, 2, 16, 16);
            }
        }
        return new Rect2i(0, 0, 0, 0);
    }

    public static Rect2i getSizeForHoverSlots(int currentSlot, int slotAmount) {
        if (slotAmount == 1) {
            return new Rect2i(9, 9, 30, 30);
        }
        if (slotAmount == 2) {
            if (currentSlot == 0) {
                return new Rect2i(6, 30, 36, 12);
            }
            if (currentSlot == 1) {
                return new Rect2i(6, 6, 36, 12);
            }
        }
        if (slotAmount == 4) {
            if (currentSlot == 0) {
                return new Rect2i(30, 30, 12, 12);
            }
            if (currentSlot == 1) {
                return new Rect2i(6, 30, 12, 12);
            }
            if (currentSlot == 2) {
                return new Rect2i(30, 6, 12, 12);
            }
            if (currentSlot == 3) {
                return new Rect2i(6, 6, 12, 12);
            }
        }
        return new Rect2i(0, 0, 0, 0);
    }

    public int getXSize() {
        return 0;
    }

    public int getYSize() {
        return 0;
    }

    public void drawBackgroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.slotAmount; ++i) {
            FluidStack fluidStack = this.fluidHandlerSupplier.get().getFluidInTank(i);
            if (fluidStack.isEmpty() && this.fluidHandlerSupplier.get().isDrawerLocked()) {
                fluidStack = this.fluidHandlerSupplier.get().getFilterStack()[i];
            }
            if (fluidStack.isEmpty()) continue;
            this.renderFluid(stack, screen, guiX, guiY, fluidStack, i, this.slotAmount);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.gui);
        int size = 48;
        Screen.m_93133_((PoseStack)stack, (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()), (float)0.0f, (float)0.0f, (int)size, (int)size, (int)size, (int)size);
        for (int i = 0; i < this.slotAmount; ++i) {
            FluidStack fluidStack = this.fluidHandlerSupplier.get().getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            int x = guiX + (Integer)this.slotPosition.apply(i).getLeft() + this.getPosX();
            int y = guiY + (Integer)this.slotPosition.apply(i).getRight() + this.getPosY();
            String amount = NumberUtils.getFormatedFluidBigNumber(fluidStack.getAmount()) + "/" + NumberUtils.getFormatedFluidBigNumber(this.slotMaxAmount.apply(i));
            float scale = 0.5f;
            stack.m_85837_(0.0, 0.0, 200.0);
            stack.m_85841_(scale, scale, scale);
            Minecraft.m_91087_().f_91062_.m_92750_(stack, amount, (float)(x + 17 - Minecraft.m_91087_().f_91062_.m_92895_(amount) / 2) * (1.0f / scale), (float)(y + 12) * (1.0f / scale), 0xFFFFFF);
            stack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
            stack.m_85837_(0.0, 0.0, -200.0);
        }
    }

    public void drawForegroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.slotAmount; ++i) {
            Rect2i rect = FluidDrawerInfoGuiAddon.getSizeForHoverSlots(i, this.slotAmount);
            int x = rect.m_110085_() + this.getPosX() + guiX;
            int y = rect.m_110086_() + this.getPosY() + guiY;
            if (mouseX <= x || mouseX >= x + rect.m_110090_() || mouseY <= y || mouseY >= y + rect.m_110091_()) continue;
            x = this.getPosX() + rect.m_110085_();
            y = this.getPosY() + rect.m_110086_();
            stack.m_85837_(0.0, 0.0, 200.0);
            GuiComponent.m_93172_((PoseStack)stack, (int)x, (int)y, (int)(x + rect.m_110090_()), (int)(y + rect.m_110091_()), (int)-2130706433);
            stack.m_85837_(0.0, 0.0, -200.0);
            ArrayList<MutableComponent> componentList = new ArrayList<MutableComponent>();
            FluidStack over = this.fluidHandlerSupplier.get().getFluidInTank(i);
            if (over.isEmpty()) {
                componentList.add(new TranslatableComponent("gui.functionalstorage.fluid").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent("Empty").m_130940_(ChatFormatting.WHITE)));
            } else {
                componentList.add(new TranslatableComponent("gui.functionalstorage.fluid").m_130940_(ChatFormatting.GOLD).m_7220_((Component)over.getDisplayName().m_6881_().m_130940_(ChatFormatting.WHITE)));
                String amount = NumberUtils.getFormatedFluidBigNumber(over.getAmount()) + "/" + NumberUtils.getFormatedFluidBigNumber(this.slotMaxAmount.apply(i));
                componentList.add(new TranslatableComponent("gui.functionalstorage.amount").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent(amount).m_130940_(ChatFormatting.WHITE)));
            }
            componentList.add(new TranslatableComponent("gui.functionalstorage.slot").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent("" + i).m_130940_(ChatFormatting.WHITE)));
            screen.m_169388_(stack, componentList, Optional.empty(), mouseX - guiX, mouseY - guiY);
        }
    }

    public void renderFluid(PoseStack stack, Screen screen, int guiX, int guiY, FluidStack fluidStack, int slot, int slotAmount) {
        TextureAtlasSprite sprite;
        AbstractTexture texture;
        ResourceLocation flowing = fluidStack.getFluid().getAttributes().getStillTexture(fluidStack);
        if (flowing != null && (texture = screen.getMinecraft().m_91097_().m_118506_(TextureAtlas.f_118259_)) instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).m_118316_(flowing)) != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            Color color = new Color(fluidStack.getFluid().getAttributes().getColor(fluidStack));
            Rect2i rect = FluidDrawerInfoGuiAddon.getSizeForSlots(slot, slotAmount);
            RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            RenderSystem.m_69478_();
            for (int x = 0; x < rect.m_110090_(); x += 16) {
                for (int y = 0; y < rect.m_110091_(); y += 16) {
                    Screen.m_93200_((PoseStack)stack, (int)(this.getPosX() + guiX + rect.m_110085_() + x), (int)(this.getPosY() + guiY + rect.m_110086_() + y), (int)0, (int)Math.min(16, rect.m_110090_() - x), (int)Math.min(16, rect.m_110091_() - y), (TextureAtlasSprite)sprite);
                }
            }
            RenderSystem.m_69461_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

