/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client.loader;

import com.buuz135.functionalstorage.block.FramedDrawerBlock;
import com.buuz135.functionalstorage.client.loader.IQuadTransformer;
import com.buuz135.functionalstorage.client.model.FramedDrawerModelData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FramedModel
implements IModelGeometry<FramedModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableMap<String, Submodel> children;
    private final ImmutableList<String> itemPasses;
    private final boolean logWarning;

    public FramedModel(ImmutableMap<String, Submodel> children, ImmutableList<String> itemPasses) {
        this(children, itemPasses, false);
    }

    private FramedModel(ImmutableMap<String, Submodel> children, ImmutableList<String> itemPasses, boolean logWarning) {
        this.children = children;
        this.itemPasses = itemPasses;
        this.logWarning = logWarning;
    }

    public BakedModel bake(IModelConfiguration context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        if (this.logWarning) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated \"parts\" field in its composite model instead of \"children\". This field will be removed in 1.20.");
        }
        Material particleLocation = context.resolveTexture("particle");
        TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
        ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            if (!context.getPartVisibility((IModelGeometryPart)entry.getValue(), true)) continue;
            Submodel model = (Submodel)entry.getValue();
            bakedPartsBuilder.put((Object)name, (Object)model.bakeModel(bakery, spriteGetter, modelState, modelLocation));
        }
        ImmutableMap bakedParts = bakedPartsBuilder.build();
        ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
        for (String name : this.itemPasses) {
            BakedModel model = (BakedModel)bakedParts.get((Object)name);
            if (model == null) {
                throw new IllegalStateException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
            }
            itemPassesBuilder.add((Object)model);
        }
        return new Baked(context.isShadedInGui(), context.isSideLit(), context.useSmoothLighting(), particle, context.getCameraTransforms(), overrides, (ImmutableMap<String, BakedModel>)bakedParts, (ImmutableList<BakedModel>)itemPassesBuilder.build());
    }

    public Collection<Material> getTextures(IModelConfiguration context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>();
        if (context.isTexturePresent("particle")) {
            textures.add(context.resolveTexture("particle"));
        }
        for (Submodel part : this.children.values()) {
            textures.addAll(part.getTextures(context, modelGetter, missingTextureErrors));
        }
        return textures;
    }

    public Collection<? extends IModelGeometryPart> getParts() {
        return this.children.values();
    }

    private static class Submodel
    implements IModelGeometryPart {
        private final String name;
        private final BlockModel model;

        private Submodel(String name, BlockModel model) {
            this.name = name;
            this.model = model;
        }

        public String name() {
            return this.name;
        }

        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            throw new UnsupportedOperationException("Attempted to call adQuads on a Submodel instance. Please don't.");
        }

        public BakedModel bakeModel(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            return this.model.m_7611_(bakery, spriteGetter, modelTransform, modelLocation);
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.model.m_5500_(modelGetter, missingTextureErrors);
        }
    }

    public class Baked
    implements IDynamicBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final ItemTransforms transforms;
        private final ImmutableMap<String, BakedModel> children;
        private final ImmutableList<BakedModel> itemPasses;

        public Baked(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ItemTransforms transforms, ItemOverrides overrides, ImmutableMap<String, BakedModel> children, ImmutableList<BakedModel> itemPasses) {
            this.children = children;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = new RetexturedOverride((BakedModel)this);
            this.transforms = transforms;
            this.itemPasses = itemPasses;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData data) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                FramedDrawerModelData framedDrawerModelData = (FramedDrawerModelData)data.getData(FramedDrawerModelData.FRAMED_PROPERTY);
                List quads = ((BakedModel)entry.getValue()).getQuads(state, side, rand, Data.resolve(data, (String)entry.getKey()));
                if (framedDrawerModelData != null && framedDrawerModelData.getDesign().containsKey(entry.getKey())) {
                    Item item = framedDrawerModelData.getDesign().get(entry.getKey());
                    quadLists.add(Baked.getQuadsUsingShape(item, quads, side, rand));
                    continue;
                }
                quadLists.add(quads);
            }
            return quadLists.stream().flatMap(Collection::stream).toList();
        }

        protected static List<BakedQuad> getQuadsUsingShape(@Nullable Item frameItem, List<BakedQuad> shape, @Nullable Direction side, Random rand) {
            if (frameItem instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)frameItem;
                BlockState state1 = blockItem.m_40614_().m_49966_();
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state1);
                Optional<List<Triple<TextureAtlasSprite, Integer, int[]>>> spriteOptional = Baked.getSpriteData(model, state1, side, rand, null);
                ArrayList<BakedQuad> returnQuads = new ArrayList<BakedQuad>();
                for (BakedQuad shapeQuad : shape) {
                    List<Triple<TextureAtlasSprite, Integer, int[]>> spriteData = spriteOptional.orElse(Baked.getSpriteFromModel(shapeQuad, model, state1, null));
                    returnQuads.addAll(Baked.framedQuad(shapeQuad, spriteData, state1.getLightEmission((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_)));
                }
                return returnQuads;
            }
            return List.of();
        }

        private static Optional<List<Triple<TextureAtlasSprite, Integer, int[]>>> getSpriteData(BakedModel model, BlockState state, @Nullable Direction side, Random rand, @Nullable Direction rotation) {
            List quads = model.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
            ArrayList<Float> positions = new ArrayList<Float>();
            ArrayList<ImmutableTriple> modelData = new ArrayList<ImmutableTriple>();
            if (!quads.isEmpty()) {
                for (BakedQuad bakedQuad : quads) {
                    float[] position = Baked.unpackVertices(bakedQuad.m_111303_(), 0, IQuadTransformer.POSITION, 3);
                    positions.add(Float.valueOf(Baked.getPositionFromDirection(position, side)));
                }
                List<Integer> index = Baked.getMinMaxPosition(positions, side);
                for (int i = 0; i < index.size(); ++i) {
                    int[] lights = new int[4];
                    for (int j = 0; j < 4; ++j) {
                        lights[j] = ((BakedQuad)quads.get(i)).m_111303_()[IQuadTransformer.UV2 + j * IQuadTransformer.STRIDE];
                    }
                    int tint = ((BakedQuad)quads.get(i)).m_111304_() ? Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, null, ((BakedQuad)quads.get(i)).m_111305_()) : -1;
                    ImmutableTriple triple = new ImmutableTriple((Object)((BakedQuad)quads.get(i)).m_173410_(), (Object)tint, (Object)lights);
                    modelData.add(triple);
                }
            }
            return quads.isEmpty() ? Optional.empty() : Optional.of(modelData);
        }

        private static float getPositionFromDirection(float[] position, Direction side) {
            Vec3i normal = new Vec3i(0, 0, 0);
            if (side != null) {
                normal = side.m_122436_();
            }
            Vector3f vector3f = new Vector3f(position[0] * (float)normal.m_123341_(), position[1] * (float)normal.m_123342_(), position[2] * (float)normal.m_123343_());
            return (float)Math.sqrt(vector3f.m_122276_(vector3f));
        }

        private static List<Integer> getMinMaxPosition(List<Float> positions, Direction side) {
            ArrayList<Integer> index = new ArrayList<Integer>();
            float minMax = side != null && side.m_122421_() == Direction.AxisDirection.POSITIVE ? Collections.max(positions).floatValue() : Collections.min(positions).floatValue();
            for (int i = 0; i < positions.size(); ++i) {
                if (!((double)Math.abs(positions.get(i).floatValue() - minMax) < 0.1)) continue;
                index.add(i);
            }
            return index;
        }

        protected static List<Triple<TextureAtlasSprite, Integer, int[]>> getSpriteFromModel(BakedQuad shape, BakedModel model, BlockState state, Direction rotation) {
            List quads = model.m_6840_(state, shape.m_111306_(), new Random());
            ArrayList<Float> positions = new ArrayList<Float>();
            ArrayList<Triple<TextureAtlasSprite, Integer, int[]>> modelData = new ArrayList<Triple<TextureAtlasSprite, Integer, int[]>>();
            if (!quads.isEmpty()) {
                for (BakedQuad bakedQuad : quads) {
                    float[] position = Baked.unpackVertices(bakedQuad.m_111303_(), 0, IQuadTransformer.POSITION, 3);
                    positions.add(Float.valueOf(Baked.getPositionFromDirection(position, shape.m_111306_())));
                }
                List<Integer> index = Baked.getMinMaxPosition(positions, shape.m_111306_());
                for (int i = 0; i < index.size(); ++i) {
                    int[] lights = new int[4];
                    for (int j = 0; j < 4; ++j) {
                        lights[j] = ((BakedQuad)quads.get(i)).m_111303_()[IQuadTransformer.UV2 + j * IQuadTransformer.STRIDE];
                    }
                    int tint = ((BakedQuad)quads.get(i)).m_111304_() ? Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, null, ((BakedQuad)quads.get(i)).m_111305_()) : -1;
                    ImmutableTriple triple = new ImmutableTriple((Object)((BakedQuad)quads.get(i)).m_173410_(), (Object)tint, (Object)lights);
                    modelData.add((Triple<TextureAtlasSprite, Integer, int[]>)triple);
                }
            }
            return quads.isEmpty() ? List.of(Triple.of((Object)((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_())), (Object)-1, (Object)new int[]{0, 0, 0, 0})) : modelData;
        }

        protected static List<BakedQuad> framedQuad(BakedQuad toCopy, List<Triple<TextureAtlasSprite, Integer, int[]>> modelData, int lightEmission) {
            lightEmission = LightTexture.m_109885_((int)lightEmission, (int)lightEmission);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (int j = 0; j < modelData.size(); ++j) {
                BakedQuad copied = new BakedQuad(Arrays.copyOf(toCopy.m_111303_(), 32), -1, toCopy.m_111306_(), (TextureAtlasSprite)modelData.get(j).getLeft(), toCopy.m_111307_());
                for (int i = 0; i < 4; ++i) {
                    float[] uv0 = Baked.unpackVertices(copied.m_111303_(), i, IQuadTransformer.UV0, 2);
                    uv0[0] = (uv0[0] - toCopy.m_173410_().m_118409_()) * (float)((TextureAtlasSprite)modelData.get(j).getLeft()).m_118405_() / (float)toCopy.m_173410_().m_118405_() + ((TextureAtlasSprite)modelData.get(j).getLeft()).m_118409_();
                    uv0[1] = (uv0[1] - toCopy.m_173410_().m_118411_()) * (float)((TextureAtlasSprite)modelData.get(j).getLeft()).m_118408_() / (float)toCopy.m_173410_().m_118408_() + ((TextureAtlasSprite)modelData.get(j).getLeft()).m_118411_();
                    int[] packedTextureData = Baked.packUV(uv0[0], uv0[1]);
                    copied.m_111303_()[IQuadTransformer.UV0 + i * IQuadTransformer.STRIDE] = packedTextureData[0];
                    copied.m_111303_()[IQuadTransformer.UV0 + 1 + i * IQuadTransformer.STRIDE] = packedTextureData[1];
                    if ((Integer)modelData.get(j).getMiddle() != -1) {
                        int packedColor;
                        int[] colors = Baked.getColorARGB(copied.m_111303_(), i);
                        int[] color1 = Baked.getColorARGB((Integer)modelData.get(j).getMiddle());
                        colors[0] = colors[0] * color1[0] / 255;
                        colors[1] = colors[1] * color1[1] / 255;
                        colors[2] = colors[2] * color1[2] / 255;
                        colors[3] = colors[3] * color1[3] / 255;
                        copied.m_111303_()[IQuadTransformer.COLOR + i * IQuadTransformer.STRIDE] = packedColor = Baked.packColor(colors[3], colors[2], colors[1], colors[0]);
                    }
                    copied.m_111303_()[IQuadTransformer.UV2 + i * IQuadTransformer.STRIDE] = Math.max(((int[])modelData.get(j).getRight())[i], lightEmission);
                }
                quads.add(copied);
            }
            return quads;
        }

        private static float[] unpackVertices(int[] vertices, int vertexIndex, int position, int count) {
            float[] floats = new float[count];
            int startIndex = vertexIndex * IQuadTransformer.STRIDE + position;
            for (int i = 0; i < count; ++i) {
                floats[i] = Float.intBitsToFloat(vertices[startIndex + i]);
            }
            return floats;
        }

        private static int[] getColorARGB(int[] vertices, int vertexIndex) {
            int color = vertices[IQuadTransformer.STRIDE * vertexIndex + IQuadTransformer.COLOR];
            return Baked.getColorARGB(color);
        }

        private static int[] getColorARGB(int color) {
            int[] argb = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
            return argb;
        }

        private static int[] getUV2(int[] vertices, int vertexIndex) {
            int[] light = new int[2];
            int uv2 = vertices[IQuadTransformer.STRIDE * vertexIndex + IQuadTransformer.UV2];
            light[0] = (uv2 & 0xFFFF) >> 4;
            light[1] = uv2 >> 20 & 0xFFFF;
            return light;
        }

        public static int[] packUV(float u, float v) {
            int[] quadData = new int[]{Float.floatToRawIntBits(u), Float.floatToRawIntBits(v)};
            return quadData;
        }

        public static int packColor(int r, int g, int b, int a) {
            return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }

        public static int packUV2(int u, int v) {
            return u << 4 | v << 20;
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
            Item item;
            FramedDrawerModelData framedDrawerModelData = (FramedDrawerModelData)data.getData(FramedDrawerModelData.FRAMED_PROPERTY);
            if (framedDrawerModelData != null && framedDrawerModelData.getDesign().containsKey("particle") && (item = framedDrawerModelData.getDesign().get("particle")) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                return Minecraft.m_91087_().m_91289_().m_110910_(blockItem.m_40614_().m_49966_()).getParticleIcon(data);
            }
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public ItemTransforms m_7442_() {
            return this.transforms;
        }

        public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
            return Collections.singletonList(Pair.of((Object)new ItemModel(this, itemStack), (Object)ItemBlockRenderTypes.m_109279_((ItemStack)itemStack, (boolean)fabulous)));
        }

        public boolean isLayered() {
            return true;
        }

        @Nullable
        public BakedModel getPart(String name) {
            return (BakedModel)this.children.get((Object)name);
        }
    }

    private class RetexturedOverride
    extends ItemOverrides {
        private final BakedModel bakedModel;

        private RetexturedOverride(BakedModel bakedModel) {
            this.bakedModel = bakedModel;
        }

        @javax.annotation.Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @javax.annotation.Nullable ClientLevel world, @javax.annotation.Nullable LivingEntity entity, int pSeed) {
            return this.bakedModel;
        }
    }

    private class ItemModel
    implements IDynamicBakedModel {
        private final Baked baked;
        private final ItemStack itemStack;

        public ItemModel(Baked baked, ItemStack itemStack) {
            this.baked = baked;
            this.itemStack = itemStack;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.baked.children.entrySet()) {
                List quads = ((BakedModel)entry.getValue()).getQuads(state, side, rand, Data.resolve(extraData, (String)entry.getKey()));
                FramedDrawerModelData framedDrawerModelData = FramedDrawerBlock.getDrawerModelData(this.itemStack);
                if (framedDrawerModelData != null && framedDrawerModelData.getDesign().containsKey(entry.getKey())) {
                    Item item = framedDrawerModelData.getDesign().get(entry.getKey());
                    quadLists.add(Baked.getQuadsUsingShape(item, quads, side, rand));
                    continue;
                }
                quadLists.add(quads);
            }
            return quadLists.stream().flatMap(Collection::stream).toList();
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.baked.m_6160_();
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        public ItemTransforms m_7442_() {
            return this.baked.m_7442_();
        }
    }

    public static final class Loader
    implements IModelLoader<FramedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public FramedModel read(JsonDeserializationContext deserializationContext, JsonObject jsonObject) {
            ArrayList<String> itemPasses = new ArrayList<String>();
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            this.readChildren(jsonObject, "children", deserializationContext, (ImmutableMap.Builder<String, Submodel>)childrenBuilder, itemPasses, false);
            boolean logWarning = this.readChildren(jsonObject, "parts", deserializationContext, (ImmutableMap.Builder<String, Submodel>)childrenBuilder, itemPasses, true);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Composite model requires a \"children\" element with at least one element.");
            }
            if (jsonObject.has("item_render_order")) {
                itemPasses.clear();
                for (JsonElement element : jsonObject.getAsJsonArray("item_render_order")) {
                    String name = element.getAsString();
                    if (!children.containsKey((Object)name)) {
                        throw new JsonParseException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
                    }
                    itemPasses.add(name);
                }
            }
            return new FramedModel((ImmutableMap<String, Submodel>)children, (ImmutableList<String>)ImmutableList.copyOf(itemPasses), logWarning);
        }

        private boolean readChildren(JsonObject jsonObject, String name, JsonDeserializationContext deserializationContext, ImmutableMap.Builder<String, Submodel> children, List<String> itemPasses, boolean logWarning) {
            if (!jsonObject.has(name)) {
                return false;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)new Submodel(name, (BlockModel)deserializationContext.deserialize((JsonElement)entry.getValue(), BlockModel.class)));
                itemPasses.add((String)entry.getKey());
            }
            return logWarning;
        }

        public void m_6213_(ResourceManager p_10758_) {
        }
    }

    public static class Data {
        public static final ModelProperty<Data> PROPERTY = new ModelProperty();
        private final Map<String, IModelData> partData;

        private Data(Map<String, IModelData> partData) {
            this.partData = partData;
        }

        @Nullable
        public IModelData get(String name) {
            return this.partData.get(name);
        }

        public static IModelData resolve(IModelData modelData, String name) {
            Data compositeData = (Data)modelData.getData(PROPERTY);
            if (compositeData == null) {
                return modelData;
            }
            IModelData partData = compositeData.get(name);
            return partData != null ? partData : modelData;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private final Map<String, IModelData> partData = new IdentityHashMap<String, IModelData>();

            public Builder with(String name, IModelData data) {
                this.partData.put(name, data);
                return this;
            }

            public Data build() {
                return new Data(this.partData);
            }
        }
    }
}

