/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.abilities;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleType;
import xyz.iwolfking.woldsvaults.init.ModEffects;

public class ColossusAbility
extends InstantManaAbility {
    private int durationTicks;
    private float size;
    private float additionalResistance;

    public ColossusAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int durationTicks, float size, float additionalResistance) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.durationTicks = durationTicks;
        this.size = size;
        this.additionalResistance = additionalResistance;
    }

    public ColossusAbility() {
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public float getSize() {
        return this.size;
    }

    public float getAdditionalResistance() {
        return this.additionalResistance;
    }

    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_(ModEffects.COLOSSUS)) {
                return Ability.ActionResult.fail();
            }
            int duration = this.getDurationTicks();
            MobEffectInstance newEffect = new MobEffectInstance(ModEffects.COLOSSUS, duration, 0, false, false, true);
            player.m_7292_(newEffect);
            return Ability.ActionResult.successCooldownDeferred();
        }).orElse(Ability.ActionResult.fail());
    }

    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits((Number)this.durationTicks, buffer);
        Adapters.FLOAT.writeBits((Number)Float.valueOf(this.size), buffer);
        Adapters.FLOAT.writeBits((Number)Float.valueOf(this.additionalResistance), buffer);
    }

    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.size = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.additionalResistance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT_SEGMENTED_7.writeNbt((Number)this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.size)).ifPresent(tag -> nbt.m_128365_("size", tag));
            Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.additionalResistance)).ifPresent(tag -> nbt.m_128365_("additionalResistance", tag));
            return nbt;
        });
    }

    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationTicks = Adapters.INT_SEGMENTED_7.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.size = Adapters.FLOAT.readNbt(nbt.m_128423_("size")).orElse(Float.valueOf(1.0f)).floatValue();
        this.additionalResistance = Adapters.FLOAT.readNbt(nbt.m_128423_("additionalResistance")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT_SEGMENTED_7.writeJson((Number)this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            Adapters.FLOAT.writeJson((Number)Float.valueOf(this.size)).ifPresent(element -> json.add("size", element));
            Adapters.FLOAT.writeJson((Number)Float.valueOf(this.additionalResistance)).ifPresent(element -> json.add("additionalResistance", element));
            return json;
        });
    }

    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationTicks = Adapters.INT_SEGMENTED_7.readJson(json.get("durationTicks")).orElse(0);
        this.size = Adapters.FLOAT.readJson(json.get("size")).orElse(Float.valueOf(1.0f)).floatValue();
        this.additionalResistance = Adapters.FLOAT.readJson(json.get("additionalResistance")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Mod.EventBusSubscriber(modid="woldsvaults", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ColossusEffect
    extends MobEffect {
        private final ScaleType scaleType;

        public ColossusEffect(MobEffectCategory mobEffectCategory, int i, ScaleType scaleType, ResourceLocation id) {
            super(mobEffectCategory, i);
            this.scaleType = scaleType;
            this.setRegistryName(id);
        }

        public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                float size = 1.0f;
                AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)((ServerLevel)player.f_19853_)).getAbilities((Player)player);
                for (ColossusAbility ability : abilities.getAll(ColossusAbility.class, Skill::isUnlocked)) {
                    size = ability.getSize();
                }
                ScaleData scaleData = this.scaleType.getScaleData((Entity)player);
                scaleData.setTargetScale(size);
                scaleData.setScaleTickDelay(scaleData.getScaleTickDelay());
            }
        }

        public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ScaleData scaleData = this.scaleType.getScaleData((Entity)player);
                scaleData.setTargetScale(1.0f);
                scaleData.setScaleTickDelay(scaleData.getScaleTickDelay());
                PlayerAbilitiesData.setAbilityOnCooldown((ServerPlayer)player, ColossusAbility.class);
            }
        }

        @SubscribeEvent
        public static void onLivingKnockback(LivingKnockBackEvent event) {
            ServerPlayer player;
            Entity entity = event.getEntity();
            if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).m_21023_(ModEffects.COLOSSUS)) {
                event.setStrength(0.0f);
            }
        }

        public static float getColossusResistance(LivingEntity entity) {
            float resistancePercentage = 0.0f;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (!player.m_21023_(ModEffects.COLOSSUS)) {
                    return resistancePercentage;
                }
                AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)((ServerLevel)player.f_19853_)).getAbilities((Player)player);
                for (ColossusAbility ability : abilities.getAll(ColossusAbility.class, Skill::isUnlocked)) {
                    resistancePercentage += ability.getAdditionalResistance();
                }
                return resistancePercentage;
            }
            return resistancePercentage;
        }
    }
}

