/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.abilities;

import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import xyz.iwolfking.woldsvaults.api.util.DelayedExecutionHelper;

public class ConcentrateAbility
extends InstantManaAbility {
    private double radius;
    private int baseEffectDuration;
    private int baseAmplitude;
    private float amplitudeScaleChance;
    private int particleSteps;
    private int particleDelay;

    public ConcentrateAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, double radius, int baseEffectDuration, int baseAmplitude, float amplitudeScaleChance, int particleSteps, int particleDelay) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.radius = radius;
        this.baseEffectDuration = baseEffectDuration;
        this.baseAmplitude = baseAmplitude;
        this.amplitudeScaleChance = amplitudeScaleChance;
        this.particleSteps = particleSteps;
        this.particleDelay = particleDelay;
    }

    public ConcentrateAbility() {
    }

    protected Ability.ActionResult doAction(SkillContext context) {
        context.getSource().as(ServerPlayer.class).map(serverPlayer -> {
            ServerLevel level = (ServerLevel)serverPlayer.f_19853_;
            level.m_5594_(null, serverPlayer.m_142538_(), SoundEvents.f_11859_, SoundSource.PLAYERS, 0.8f, 1.2f);
            List entities = level.m_6443_(LivingEntity.class, serverPlayer.m_142469_().m_82400_((double)AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)serverPlayer, (Skill)this, (float)((float)this.getRadius()))), e -> !(e instanceof ServerPlayer) && !(e instanceof PetEntity));
            ArrayList<Pair> effectsToProcess = new ArrayList<Pair>();
            for (LivingEntity entity : entities) {
                ArrayList<MobEffect> effectsToRemove = new ArrayList<MobEffect>();
                for (MobEffectInstance mobEffectInstance : entity.m_21220_()) {
                    if (ConcentrateAbility.shouldIgnoreEffect(mobEffectInstance.m_19544_())) continue;
                    effectsToRemove.add(mobEffectInstance.m_19544_());
                    MobEffect positive = ConcentrateAbility.getEffectConversion(mobEffectInstance.m_19544_(), level.m_5822_());
                    if (positive == null) continue;
                    effectsToProcess.add(Pair.of((Object)entity.m_20182_(), (Object)positive));
                }
                for (MobEffect mobEffect : effectsToRemove) {
                    entity.m_21195_(mobEffect);
                }
            }
            for (Pair p : effectsToProcess) {
                Vec3 from = (Vec3)p.getLeft();
                MobEffect effect = (MobEffect)p.getRight();
                Vector3f[] vector3fArray = ConcentrateAbility.getEffectColors(effect);
                ConcentrateAbility.spawnColoredParticleLine(level, from, () -> ((ServerPlayer)serverPlayer).m_20182_(), vector3fArray[0], vector3fArray[1], this.particleSteps, this.particleDelay, () -> {
                    level.m_5594_(null, serverPlayer.m_142538_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.1f);
                    if (serverPlayer.m_21023_(effect)) {
                        MobEffectInstance currentEffectInstance = serverPlayer.m_21124_(effect);
                        if (currentEffectInstance == null) {
                            return;
                        }
                        int currentAmp = currentEffectInstance.m_19564_();
                        float currentAmplitudeScaleChance = this.amplitudeScaleChance;
                        if (currentAmplitudeScaleChance > 1.0f) {
                            float i = 1.0f;
                            while (currentAmplitudeScaleChance >= 1.0f) {
                                ++currentAmp;
                                currentAmplitudeScaleChance -= i;
                                i += 1.0f;
                            }
                        }
                        if (level.m_5822_().nextFloat() <= currentAmplitudeScaleChance) {
                            ++currentAmp;
                        }
                        serverPlayer.m_147215_(new MobEffectInstance(effect, currentEffectInstance.m_19557_() + (int)EffectDurationHelper.adjustEffectDuration((LivingEntity)serverPlayer, (float)this.baseEffectDuration), currentAmp, false, true), (Entity)serverPlayer);
                    } else {
                        serverPlayer.m_7292_(new MobEffectInstance(effect, (int)EffectDurationHelper.adjustEffectDuration((LivingEntity)serverPlayer, (float)this.baseEffectDuration), this.baseAmplitude, false, true));
                    }
                });
            }
            this.putOnCooldown(context);
            return Ability.ActionResult.successCooldownImmediate();
        }).orElse(Ability.ActionResult.fail());
        return super.doAction(context);
    }

    private static void spawnColoredParticleLine(ServerLevel level, Vec3 from, Supplier<Vec3> toSupplier, Vector3f startColor, Vector3f endColor, int steps, int ticksBetween, Runnable onArrival) {
        Vec3 mid = from.m_82520_(0.0, 1.0, 0.0);
        Vec3 controlOffset = new Vec3(level.f_46441_.nextDouble() - 0.5, 1.5 + level.f_46441_.nextDouble(), level.f_46441_.nextDouble() - 0.5);
        double speedExponent = 2.0;
        int i = 0;
        while (i <= steps) {
            int stepIndex = i++;
            double linearT = (double)stepIndex / (double)steps;
            double t = Math.pow(linearT, 1.0 / speedExponent);
            DelayedExecutionHelper.schedule(level, stepIndex * ticksBetween, () -> {
                Vec3 to = (Vec3)toSupplier.get();
                Vec3 diff = to.m_82546_(from);
                Vec3 control = mid.m_82549_(controlOffset);
                Vec3 pos = from.m_82490_((1.0 - t) * (1.0 - t)).m_82549_(control.m_82490_(2.0 * (1.0 - t) * t)).m_82549_(to.m_82490_(t * t));
                float r = (float)((double)startColor.m_122239_() + t * (double)(endColor.m_122239_() - startColor.m_122239_()));
                float g = (float)((double)startColor.m_122260_() + t * (double)(endColor.m_122260_() - startColor.m_122260_()));
                float b = (float)((double)startColor.m_122269_() + t * (double)(endColor.m_122269_() - startColor.m_122269_()));
                DustParticleOptions particle = new DustParticleOptions(new Vector3f(r, g, b), 1.0f);
                level.m_8767_((ParticleOptions)particle, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                if (stepIndex == steps && onArrival != null) {
                    onArrival.run();
                }
            });
        }
    }

    private static MobEffect getEffectConversion(MobEffect effect, Random random) {
        if (effect == MobEffects.f_19597_ || effect == ModEffects.CHILLED || effect == MobEffects.f_19596_) {
            return xyz.iwolfking.woldsvaults.init.ModEffects.QUICKENING;
        }
        if (effect == MobEffects.f_19613_ || effect == ModEffects.BLEED || effect == MobEffects.f_19600_) {
            return xyz.iwolfking.woldsvaults.init.ModEffects.EMPOWER;
        }
        if (effect == MobEffects.f_19614_) {
            return random.nextBoolean() ? ModEffects.PURIFYING_AURA : MobEffects.f_19605_;
        }
        if (effect == ModEffects.VULNERABLE) {
            return random.nextBoolean() ? MobEffects.f_19606_ : xyz.iwolfking.woldsvaults.init.ModEffects.EMPOWER;
        }
        if (effect == ModEffects.FREEZE || effect == ModEffects.HYPOTHERMIA) {
            return random.nextBoolean() ? MobEffects.f_19607_ : MobEffects.f_19598_;
        }
        if (effect == ModEffects.TAUNT_REPEL_MOB) {
            return random.nextBoolean() ? AMEffectRegistry.SOULSTEAL : MobEffects.f_19611_;
        }
        if (effect == MobEffects.f_19590_) {
            return MobEffects.f_19621_;
        }
        if (effect == MobEffects.f_19615_) {
            return MobEffects.f_19605_;
        }
        if (effect == MobEffects.f_19612_) {
            return MobEffects.f_19618_;
        }
        if (effect == xyz.iwolfking.woldsvaults.init.ModEffects.SHRINKING) {
            return xyz.iwolfking.woldsvaults.init.ModEffects.GROWING;
        }
        if (effect == MobEffects.f_19620_) {
            return MobEffects.f_19592_;
        }
        if (effect == MobEffects.f_19598_) {
            return MobEffects.f_19618_;
        }
        return effect;
    }

    private static Vector3f[] getEffectColors(MobEffect effect) {
        if (effect == xyz.iwolfking.woldsvaults.init.ModEffects.QUICKENING) {
            return new Vector3f[]{new Vector3f(0.2f, 0.7f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f)};
        }
        if (effect == xyz.iwolfking.woldsvaults.init.ModEffects.EMPOWER) {
            return new Vector3f[]{new Vector3f(1.0f, 0.2f, 0.2f), new Vector3f(1.0f, 0.6f, 0.1f)};
        }
        if (effect == ModEffects.PURIFYING_AURA) {
            return new Vector3f[]{new Vector3f(0.4f, 1.0f, 0.7f), new Vector3f(1.0f, 0.95f, 0.6f)};
        }
        if (effect == MobEffects.f_19606_) {
            return new Vector3f[]{new Vector3f(0.6f, 0.6f, 0.8f), new Vector3f(0.3f, 0.5f, 1.0f)};
        }
        if (effect == MobEffects.f_19607_) {
            return new Vector3f[]{new Vector3f(1.0f, 0.5f, 0.0f), new Vector3f(0.9f, 0.2f, 0.0f)};
        }
        if (effect == AMEffectRegistry.SOULSTEAL) {
            return new Vector3f[]{new Vector3f(0.3f, 0.0f, 0.5f), new Vector3f(0.1f, 0.9f, 0.9f)};
        }
        if (effect == MobEffects.f_19621_) {
            return new Vector3f[]{new Vector3f(0.0f, 0.9f, 0.3f), new Vector3f(0.9f, 0.9f, 0.2f)};
        }
        if (effect == MobEffects.f_19605_) {
            return new Vector3f[]{new Vector3f(0.3f, 0.9f, 0.3f), new Vector3f(1.0f, 0.84f, 0.0f)};
        }
        if (effect == MobEffects.f_19618_) {
            return new Vector3f[]{new Vector3f(0.9f, 0.3f, 0.4f), new Vector3f(1.0f, 0.85f, 0.3f)};
        }
        if (effect == xyz.iwolfking.woldsvaults.init.ModEffects.GROWING) {
            return new Vector3f[]{new Vector3f(0.1f, 0.6f, 0.1f), new Vector3f(0.7f, 1.0f, 0.4f)};
        }
        if (effect == MobEffects.f_19592_) {
            return new Vector3f[]{new Vector3f(0.0f, 0.8f, 0.9f), new Vector3f(0.8f, 1.0f, 1.0f)};
        }
        return new Vector3f[]{new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.9f, 0.4f)};
    }

    private static boolean shouldIgnoreEffect(MobEffect effect) {
        return effect.equals(xyz.iwolfking.woldsvaults.init.ModEffects.REAVING) || effect.equals(xyz.iwolfking.woldsvaults.init.ModEffects.ECHOING) || effect.equals(ModEffects.NOVA_DOT) || effect.equals(ModEffects.NO_AI) || effect.equals(ModEffects.GLACIAL_SHATTER);
    }

    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.DOUBLE.writeBits((Number)this.radius, buffer);
        Adapters.INT.writeBits((Number)this.baseEffectDuration, buffer);
        Adapters.INT.writeBits((Number)this.baseAmplitude, buffer);
        Adapters.FLOAT.writeBits((Number)Float.valueOf(this.amplitudeScaleChance), buffer);
        Adapters.INT.writeBits((Number)this.particleSteps, buffer);
        Adapters.INT.writeBits((Number)this.particleDelay, buffer);
    }

    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radius = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
        this.baseEffectDuration = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.baseAmplitude = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.amplitudeScaleChance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.particleSteps = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
        this.particleDelay = (Integer)Adapters.INT.readBits(buffer).orElseThrow();
    }

    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.DOUBLE.writeNbt((Number)this.radius).ifPresent(tag -> nbt.m_128365_("radius", tag));
            Adapters.INT.writeNbt((Number)this.baseEffectDuration).ifPresent(tag -> nbt.m_128365_("baseEffectDuration", tag));
            Adapters.INT.writeNbt((Number)this.baseAmplitude).ifPresent(tag -> nbt.m_128365_("baseAmplitude", tag));
            Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.amplitudeScaleChance)).ifPresent(tag -> nbt.m_128365_("amplitudeScaleChance", tag));
            Adapters.INT.writeNbt((Number)this.particleSteps).ifPresent(tag -> nbt.m_128365_("particleSteps", tag));
            Adapters.INT.writeNbt((Number)this.particleDelay).ifPresent(tag -> nbt.m_128365_("particleDelay", tag));
            return nbt;
        });
    }

    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.radius = Adapters.DOUBLE.readNbt(nbt.m_128423_("radius")).orElse(0.0);
        this.baseEffectDuration = Adapters.INT.readNbt(nbt.m_128423_("baseEffectDuration")).orElse(0);
        this.baseAmplitude = Adapters.INT.readNbt(nbt.m_128423_("baseAmplitude")).orElse(0);
        this.amplitudeScaleChance = Adapters.FLOAT.readNbt(nbt.m_128423_("amplitudeScaleChance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.particleSteps = Adapters.INT.readNbt(nbt.m_128423_("particleSteps")).orElse(0);
        this.particleDelay = Adapters.INT.readNbt(nbt.m_128423_("particleDelay")).orElse(0);
    }

    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.DOUBLE.writeJson((Number)this.radius).ifPresent(jsonElement -> json.add("radius", jsonElement));
            Adapters.INT.writeJson((Number)this.baseEffectDuration).ifPresent(jsonElement -> json.add("baseEffectDuration", jsonElement));
            Adapters.INT.writeJson((Number)this.baseAmplitude).ifPresent(jsonElement -> json.add("baseAmplitude", jsonElement));
            Adapters.FLOAT.writeJson((Number)Float.valueOf(this.amplitudeScaleChance)).ifPresent(jsonElement -> json.add("amplitudeScaleChance", jsonElement));
            Adapters.INT.writeJson((Number)this.particleSteps).ifPresent(jsonElement -> json.add("particleSteps", jsonElement));
            Adapters.INT.writeJson((Number)this.particleDelay).ifPresent(jsonElement -> json.add("particleDelay", jsonElement));
            return json;
        });
    }

    public void readJson(JsonObject json) {
        super.readJson(json);
        this.radius = Adapters.DOUBLE.readJson(json.get("radius")).orElse(0.0);
        this.baseEffectDuration = Adapters.INT.readJson(json.get("baseEffectDuration")).orElse(0);
        this.baseAmplitude = Adapters.INT.readJson(json.get("baseAmplitude")).orElse(0);
        this.amplitudeScaleChance = Adapters.FLOAT.readJson(json.get("amplitudeScaleChance")).orElse(Float.valueOf(0.0f)).floatValue();
        this.particleSteps = Adapters.INT.readJson(json.get("particleSteps")).orElse(0);
        this.particleDelay = Adapters.INT.readJson(json.get("particleDelay")).orElse(0);
    }

    public double getRadius() {
        return this.radius;
    }

    public int getBaseEffectDuration() {
        return this.baseEffectDuration;
    }

    public int getBaseAmplitude() {
        return this.baseAmplitude;
    }

    public float getAmplitudeScaleChance() {
        return this.amplitudeScaleChance;
    }

    public int getParticleSteps() {
        return this.particleSteps;
    }

    public int getParticleDelay() {
        return this.particleDelay;
    }
}

