/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.abilities;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.EffectCloudEntity;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.util.calc.AreaOfEffectHelper;
import iskallia.vault.util.calc.EffectDurationHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import xyz.iwolfking.woldsvaults.api.util.WoldAttributeHelper;

public class ExpungeAbility
extends InstantManaAbility {
    private float radiusMultiplier;
    private float durationMultiplier;

    public float getRadiusMultiplier() {
        return this.radiusMultiplier;
    }

    public float getDurationMultiplier() {
        return this.durationMultiplier;
    }

    public ExpungeAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, float radiusMultiplier, float durationMultiplier) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.radiusMultiplier = radiusMultiplier;
        this.durationMultiplier = durationMultiplier;
    }

    public ExpungeAbility() {
    }

    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            WoldAttributeHelper.withSnapshot((LivingEntity)player, true, (playerEntity, snapshot) -> ((List)snapshot.getAttributeValue(ModGearAttributes.EFFECT_CLOUD_WHEN_HIT, VaultGearAttributeTypeMerger.asList())).forEach(cloud -> {
                MobEffect effect = cloud.getPrimaryEffect();
                if (effect != null) {
                    EffectCloudEntity cloudEntity = new EffectCloudEntity(playerEntity.m_183503_(), playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_());
                    cloud.apply(cloudEntity);
                    cloudEntity.setRadius(AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)playerEntity, null, (float)(cloudEntity.getRadius() * this.getRadiusMultiplier())));
                    cloudEntity.setOwner(playerEntity);
                    cloudEntity.setDuration(EffectDurationHelper.adjustEffectDurationFloor((LivingEntity)playerEntity, (float)((float)cloudEntity.getDuration() * this.getDurationMultiplier())));
                    playerEntity.m_183503_().m_7967_((Entity)cloudEntity);
                }
            }));
            WoldAttributeHelper.withSnapshot((LivingEntity)player, true, (playerEntity, snapshot) -> ((List)snapshot.getAttributeValue(ModGearAttributes.EFFECT_CLOUD, VaultGearAttributeTypeMerger.asList())).forEach(cloud -> {
                MobEffect effect = cloud.getPrimaryEffect();
                if (effect != null) {
                    EffectCloudEntity cloudEntity = new EffectCloudEntity(playerEntity.m_183503_(), playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_());
                    cloud.apply(cloudEntity);
                    cloudEntity.setRadius(AreaOfEffectHelper.adjustAreaOfEffect((LivingEntity)playerEntity, null, (float)cloudEntity.getRadius()));
                    cloudEntity.setOwner(playerEntity);
                    cloudEntity.setDuration(EffectDurationHelper.adjustEffectDurationFloor((LivingEntity)playerEntity, (float)cloudEntity.getDuration()));
                    playerEntity.m_183503_().m_7967_((Entity)cloudEntity);
                }
            }));
            player.m_183503_().m_5594_(null, player.m_20097_(), ModSounds.OVERGROWN_ZOMBIE_DEATH, SoundSource.PLAYERS, 1.0f, 0.5f);
            this.putOnCooldown(context);
            return Ability.ActionResult.successCooldownDeferred();
        }).orElse(Ability.ActionResult.fail());
    }

    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits((Number)Float.valueOf(this.radiusMultiplier), buffer);
        Adapters.FLOAT.writeBits((Number)Float.valueOf(this.durationMultiplier), buffer);
    }

    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.radiusMultiplier = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.durationMultiplier = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.durationMultiplier)).ifPresent(tag -> nbt.m_128365_("durationMultiplier", tag));
            Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.radiusMultiplier)).ifPresent(tag -> nbt.m_128365_("radiusMultiplier", tag));
            return nbt;
        });
    }

    public void readNbt(CompoundTag nbt) {
        Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.durationMultiplier)).ifPresent(tag -> nbt.m_128365_("durationMultiplier", tag));
        Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.radiusMultiplier)).ifPresent(tag -> nbt.m_128365_("radiusMultiplier", tag));
        super.readNbt(nbt);
    }

    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson((Number)Float.valueOf(this.durationMultiplier)).ifPresent(element -> json.add("durationMultiplier", element));
            Adapters.FLOAT.writeJson((Number)Float.valueOf(this.radiusMultiplier)).ifPresent(element -> json.add("radiusMultiplier", element));
            return json;
        });
    }

    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationMultiplier = Adapters.FLOAT.readJson(json.get("durationMultiplier")).orElse(Float.valueOf(1.0f)).floatValue();
        this.radiusMultiplier = Adapters.FLOAT.readJson(json.get("radiusMultiplier")).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

