/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.abilities;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.HoldManaAbility;
import iskallia.vault.skill.base.SkillContext;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import xyz.iwolfking.woldsvaults.init.ModEffects;

public class LevitateAbility
extends HoldManaAbility {
    private int levitateStrength;

    public LevitateAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCostPerSecond, int levitateStrength) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCostPerSecond);
        this.levitateStrength = levitateStrength;
    }

    public LevitateAbility() {
    }

    public float getLevitateSpeed() {
        return (float)(this.levitateStrength + 1) * 0.9f;
    }

    public int getLevitateStrength() {
        return this.levitateStrength;
    }

    protected void doParticles(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.NOVA_CLOUD.get()), player.m_20185_(), player.m_20186_(), player.m_20189_(), 2, 0.2, 0.5, 0.2, 0.05));
    }

    public Ability.TickResult doActiveTick(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            Ability.TickResult result = super.doActiveTick(context);
            if (result != Ability.TickResult.COOLDOWN) {
                MobEffectInstance newEffect = new MobEffectInstance(ModEffects.LEVITATEII, 100, this.levitateStrength, false, false, true);
                player.m_7292_(newEffect);
                this.doParticles(context);
            }
            return result;
        }).orElse(Ability.TickResult.PASS);
    }

    public boolean onKeyUp(SkillContext context) {
        context.getSource().as(ServerPlayer.class).map(player -> {
            player.m_21195_(ModEffects.LEVITATEII);
            return true;
        });
        return super.onKeyUp(context);
    }

    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits((Number)this.levitateStrength, buffer);
    }

    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.levitateStrength = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt((Number)this.levitateStrength).ifPresent(tag -> nbt.m_128365_("levitateStrength", tag));
            return nbt;
        });
    }

    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.levitateStrength = Adapters.INT.readNbt(nbt.m_128423_("levitateStrength")).orElse(0);
    }

    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson((Number)this.levitateStrength).ifPresent(element -> json.add("levitateStrength", element));
            return json;
        });
    }

    public void readJson(JsonObject json) {
        super.readJson(json);
        this.levitateStrength = Adapters.INT.readJson(json.get("levitateStrength")).orElse(0);
    }
}

