/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.abilities;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.InstantManaAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleType;
import xyz.iwolfking.woldsvaults.init.ModEffects;

public class SneakyGetawayAbility
extends InstantManaAbility {
    private int durationTicks;
    private float size;
    private float speedPercentAdded;

    public SneakyGetawayAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, float manaCost, int durationTicks, float size, float speedPercentAdded) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, manaCost);
        this.durationTicks = durationTicks;
        this.size = size;
        this.speedPercentAdded = speedPercentAdded;
    }

    public SneakyGetawayAbility() {
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeedPercentAdded() {
        return this.speedPercentAdded;
    }

    protected Ability.ActionResult doAction(SkillContext context) {
        return context.getSource().as(ServerPlayer.class).map(player -> {
            if (player.m_21023_(ModEffects.SNEAKY_GETAWAY)) {
                return Ability.ActionResult.fail();
            }
            int duration = this.getDurationTicks();
            MobEffectInstance newEffect = new MobEffectInstance(ModEffects.SNEAKY_GETAWAY, duration, 0, false, false, true);
            player.m_7292_(newEffect);
            return Ability.ActionResult.successCooldownDeferred();
        }).orElse(Ability.ActionResult.fail());
    }

    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits((Number)this.durationTicks, buffer);
        Adapters.FLOAT.writeBits((Number)Float.valueOf(this.size), buffer);
        Adapters.FLOAT.writeBits((Number)Float.valueOf(this.speedPercentAdded), buffer);
    }

    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.size = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.speedPercentAdded = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT_SEGMENTED_7.writeNbt((Number)this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.size)).ifPresent(tag -> nbt.m_128365_("size", tag));
            Adapters.FLOAT.writeNbt((Number)Float.valueOf(this.speedPercentAdded)).ifPresent(tag -> nbt.m_128365_("speedPercentAdded", tag));
            return nbt;
        });
    }

    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.durationTicks = Adapters.INT_SEGMENTED_7.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.size = Adapters.FLOAT.readNbt(nbt.m_128423_("size")).orElse(Float.valueOf(1.0f)).floatValue();
        this.speedPercentAdded = Adapters.FLOAT.readNbt(nbt.m_128423_("speedPercentAdded")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT_SEGMENTED_7.writeJson((Number)this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            Adapters.FLOAT.writeJson((Number)Float.valueOf(this.size)).ifPresent(element -> json.add("size", element));
            Adapters.FLOAT.writeJson((Number)Float.valueOf(this.speedPercentAdded)).ifPresent(element -> json.add("speedPercentAdded", element));
            return json;
        });
    }

    public void readJson(JsonObject json) {
        super.readJson(json);
        this.durationTicks = Adapters.INT_SEGMENTED_7.readJson(json.get("durationTicks")).orElse(0);
        this.size = Adapters.FLOAT.readJson(json.get("size")).orElse(Float.valueOf(1.0f)).floatValue();
        this.speedPercentAdded = Adapters.FLOAT.readJson(json.get("speedPercentAdded")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class SneakyGetawayEffect
    extends MobEffect {
        private final ScaleType scaleType;
        private static final UUID SNEAKY_GETAWAY_SPEED_ADDITION_UUID = UUID.fromString("42171e94-3ecd-4ca2-ac3f-2aa4c7cb125b");

        public SneakyGetawayEffect(MobEffectCategory mobEffectCategory, int i, ScaleType scaleType, ResourceLocation id) {
            super(mobEffectCategory, i);
            this.scaleType = scaleType;
            this.setRegistryName(id);
        }

        public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                float size = 1.0f;
                float speedPercentAdded = 0.0f;
                AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)((ServerLevel)player.f_19853_)).getAbilities((Player)player);
                for (SneakyGetawayAbility ability : abilities.getAll(SneakyGetawayAbility.class, Skill::isUnlocked)) {
                    size = ability.getSize();
                    speedPercentAdded = ability.getSpeedPercentAdded();
                }
                ScaleData scaleData = this.scaleType.getScaleData((Entity)player);
                scaleData.setScale(size);
                AttributeInstance speedAtt = player.m_21051_(Attributes.f_22279_);
                if (speedAtt != null && size != 0.0f) {
                    speedAtt.m_22118_(new AttributeModifier(SNEAKY_GETAWAY_SPEED_ADDITION_UUID, "SneakyGetawaySpeedAddition", (double)speedPercentAdded, AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
        }

        public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ScaleData scaleData = this.scaleType.getScaleData((Entity)player);
                scaleData.setTargetScale(1.0f);
                scaleData.setScaleTickDelay(scaleData.getScaleTickDelay());
                AttributeInstance speedAtt = player.m_21051_(Attributes.f_22279_);
                if (speedAtt != null) {
                    speedAtt.m_22120_(SNEAKY_GETAWAY_SPEED_ADDITION_UUID);
                }
                PlayerAbilitiesData.setAbilityOnCooldown((ServerPlayer)player, SneakyGetawayAbility.class);
            }
        }
    }
}

