/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.abilities;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.ability.effect.spi.AbstractVeinMinerAbility;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import xyz.iwolfking.woldsvaults.api.util.ducks.DuckGetRange;

public class VeinMinerChainAbility
extends AbstractVeinMinerAbility
implements DuckGetRange {
    private int range;

    public VeinMinerChainAbility(int unlockLevel, int learnPointCost, int regretPointCost, int cooldownTicks, int blockLimit, int range) {
        super(unlockLevel, learnPointCost, regretPointCost, cooldownTicks, blockLimit);
        this.range = range;
    }

    public VeinMinerChainAbility() {
    }

    @Override
    public int getRange() {
        return this.range;
    }

    protected ItemStack getVeinMiningItemProxy(Player player) {
        return player.m_21120_(InteractionHand.MAIN_HAND).m_41777_();
    }

    public boolean shouldVoid(ServerLevel level, ServerPlayer player, BlockState target) {
        return false;
    }

    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits((Number)this.range, buffer);
    }

    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.range = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
    }

    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt((Number)this.range).ifPresent(tag -> nbt.m_128365_("range", tag));
            return nbt;
        });
    }

    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.range = Adapters.INT.readNbt(nbt.m_128423_("range")).orElse(1);
    }

    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson((Number)this.range).ifPresent(element -> json.add("range", element));
            return json;
        });
    }

    public void readJson(JsonObject json) {
        super.readJson(json);
        this.range = Adapters.INT.readJson(json.get("range")).orElse(1);
    }
}

