/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.abilities.flexible;

import iskallia.vault.skill.ability.effect.ImplodeAbility;
import iskallia.vault.skill.ability.effect.SmiteAbility;
import iskallia.vault.skill.ability.effect.spi.AbstractNovaAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jline.utils.Log;
import xyz.iwolfking.woldsvaults.abilities.flexible.FlexibleImplode;
import xyz.iwolfking.woldsvaults.abilities.flexible.FlexibleNova;
import xyz.iwolfking.woldsvaults.abilities.flexible.FlexibleSmite;

public class FlexibleAbility {
    public float cast(String ability, Player player, Entity target) {
        Optional<Ability> abilityToCast = this.getAbilityData(ability, PlayerAbilitiesData.get((ServerLevel)((ServerLevel)player.f_19853_)).getAbilities(player));
        return abilityToCast.map(value -> Float.valueOf(this.castAbility(ability, (Ability)value, player, target))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    protected float castAbility(String ability, Ability abilityToCast, Player player, Entity target) {
        float durabilityDamage = 0.0f;
        Log.info((Object[])new Object[]{"Ability: " + abilityToCast});
        switch (ability) {
            case "Nova": {
                FlexibleNova novaAbility = new FlexibleNova();
                novaAbility.cast(player, target, (AbstractNovaAbility)abilityToCast);
                durabilityDamage = ((AbstractNovaAbility)abilityToCast).getManaCost();
                break;
            }
            case "Implode": {
                FlexibleImplode implodeAbility = new FlexibleImplode();
                if (!(target instanceof LivingEntity)) break;
                durabilityDamage = implodeAbility.cast(player, (LivingEntity)target, (ImplodeAbility)abilityToCast);
                break;
            }
            case "Smite": {
                FlexibleSmite smiteAbility = new FlexibleSmite();
                durabilityDamage = smiteAbility.cast(player, target, (SmiteAbility)abilityToCast);
                break;
            }
        }
        return durabilityDamage;
    }

    public Optional<Ability> getAbilityData(String ability, AbilityTree tree) {
        return tree.getForId(ability).map(skill -> {
            Skill activeSkill;
            if (skill instanceof SpecializedSkill) {
                SpecializedSkill specialized = (SpecializedSkill)skill;
                activeSkill = specialized.getSpecialization();
            } else {
                activeSkill = skill;
            }
            Skill var2 = activeSkill;
            if (var2 instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)var2;
                activeSkill = tiered.getChild();
            } else {
                activeSkill = var2;
            }
            var2 = activeSkill;
            return (Ability)(var2 instanceof Ability ? var2 : null);
        });
    }
}

