/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.core.vault_events;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import xyz.iwolfking.woldsvaults.api.core.vault_events.DelayedSequenceHandler;
import xyz.iwolfking.woldsvaults.api.core.vault_events.lib.EventTag;
import xyz.iwolfking.woldsvaults.api.core.vault_events.lib.VaultEventTask;
import xyz.iwolfking.woldsvaults.objectives.data.EnchantedEventsRegistry;

public class VaultEvent {
    private final EventDisplayType eventDisplayType;
    private final Set<EventTag> eventTags;
    private final TextComponent eventMessage;
    private final String eventName;
    private final TextComponent eventDescription;
    private final TextColor nameColor;
    private final List<VaultEventTask> eventTasks;
    private int cascadingValue = 85;

    public VaultEvent(String eventName, TextComponent eventMessage, TextColor nameColor, TextComponent eventDescription, EventDisplayType eventDisplayType, Set<EventTag> eventTags, List<VaultEventTask> eventTasks) {
        this.eventDisplayType = eventDisplayType;
        this.eventTags = eventTags;
        this.eventMessage = eventMessage;
        this.eventName = eventName;
        this.eventDescription = eventDescription;
        this.nameColor = nameColor;
        this.eventTasks = eventTasks;
    }

    public void triggerEvent(Supplier<BlockPos> pos, ServerPlayer player, Vault vault, boolean shouldCascade, EventDisplayType displayOverride) {
        if (displayOverride != null) {
            this.sendEventMessages(vault, player, displayOverride);
        } else {
            this.sendEventMessages(vault, player);
        }
        if (shouldCascade) {
            this.cascadeEvent(vault, player);
        }
        DelayedSequenceHandler.startSequence(this.eventTasks, pos, player, vault);
    }

    public void triggerEvent(Supplier<BlockPos> pos, ServerPlayer player, Vault vault) {
        this.triggerEvent(pos, player, vault, false, null);
    }

    public void cascadeEvent(Vault vault, ServerPlayer originator) {
        Random random = new Random();
        for (Listener listener : ((Listeners)vault.get(Vault.LISTENERS)).getAll()) {
            if (random.nextInt(0, 100) >= this.cascadingValue) {
                listener.getPlayer().ifPresent(other -> {
                    if (originator.equals(other) && random.nextInt(99) + 1 < this.cascadingValue) {
                        return;
                    }
                    other.f_19853_.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12001_, SoundSource.PLAYERS, 0.9f, 1.2f);
                    other.m_5661_(this.getCascadingEventMessage(originator), false);
                    this.cascadingValue += 3;
                    ((VaultEvent)EnchantedEventsRegistry.getEvents().getRandom().get()).triggerEvent(() -> ((ServerPlayer)other).m_20097_(), (ServerPlayer)other, vault);
                });
                continue;
            }
            if (random.nextInt(0, 100) < 75 || this.cascadingValue <= 85) continue;
            --this.cascadingValue;
        }
    }

    public Component getLegacyEventMessage(ServerPlayer target) {
        TextComponent eventMessage = new TextComponent("");
        eventMessage.m_7220_(target.m_5446_());
        eventMessage.m_7220_((Component)new TextComponent(" encountered a ").m_130940_(ChatFormatting.GRAY));
        eventMessage.m_7220_((Component)new TextComponent(this.eventName + " Event!").m_130948_(Style.f_131099_.m_131148_(this.nameColor)).m_130948_(this.getHoverDescription()));
        return eventMessage;
    }

    public Component getCascadingEventMessage(ServerPlayer originator) {
        TextComponent cascadeMessage = new TextComponent("");
        cascadeMessage.m_7220_(originator.m_5446_());
        cascadeMessage.m_130946_("'s ").m_130948_(originator.m_5446_().m_7383_());
        cascadeMessage.m_130946_(this.eventName).m_130948_(Style.f_131099_.m_131148_(this.nameColor)).m_130948_(this.getHoverDescription());
        cascadeMessage.m_130946_(" event has cascaded onto you!").m_130940_(ChatFormatting.GRAY);
        return cascadeMessage;
    }

    public void sendEventMessages(Vault vault, ServerPlayer originator, EventDisplayType type) {
        switch (type) {
            case NONE: {
                return;
            }
            case ACTION_BAR: {
                this.handleActionBarMessage(originator);
                break;
            }
            case CHAT_MESSAGE_TARGET: {
                this.handleChatMessage(originator, vault, false);
                break;
            }
            case CHAT_MESSAGE_ALL: {
                this.handleChatMessage(originator, vault, true);
                break;
            }
            default: {
                this.handleLegacyEventMessage(originator, vault);
            }
        }
    }

    public void sendEventMessages(Vault vault, ServerPlayer originator) {
        switch (this.eventDisplayType) {
            case NONE: {
                return;
            }
            case ACTION_BAR: {
                this.handleActionBarMessage(originator);
                break;
            }
            case CHAT_MESSAGE_TARGET: {
                this.handleChatMessage(originator, vault, false);
                break;
            }
            case CHAT_MESSAGE_ALL: {
                this.handleChatMessage(originator, vault, true);
                break;
            }
            default: {
                this.handleLegacyEventMessage(originator, vault);
            }
        }
    }

    public void handleActionBarMessage(ServerPlayer player) {
        player.m_5661_((Component)this.eventMessage, true);
    }

    public void handleChatMessage(ServerPlayer target, Vault vault, boolean shouldSendAll) {
        if (this.eventDisplayType.equals((Object)EventDisplayType.CHAT_MESSAGE_TARGET)) {
            target.m_5661_((Component)this.eventMessage, false);
            return;
        }
        for (Listener listener : ((Listeners)vault.get(Vault.LISTENERS)).getAll()) {
            listener.getPlayer().ifPresent(other -> {
                target.f_19853_.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
                other.m_5661_((Component)this.eventMessage, false);
            });
        }
    }

    public TextComponent getEventMessage() {
        return this.eventMessage;
    }

    public void handleLegacyEventMessage(ServerPlayer target, Vault vault) {
        if (this.eventDisplayType.equals((Object)EventDisplayType.CHAT_MESSAGE_TARGET)) {
            target.m_5661_(this.getLegacyEventMessage(target), false);
            return;
        }
        for (Listener listener : ((Listeners)vault.get(Vault.LISTENERS)).getAll()) {
            listener.getPlayer().ifPresent(other -> {
                target.f_19853_.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
                other.m_5661_(this.getLegacyEventMessage(target), false);
            });
        }
    }

    public Component getEventDescriptor() {
        return this.eventDescription;
    }

    public Style getHoverDescription() {
        return Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)this.getEventDescriptor()));
    }

    public Set<EventTag> getEventTags() {
        return this.eventTags;
    }

    public static enum EventDisplayType {
        NONE,
        CHAT_MESSAGE_TARGET,
        CHAT_MESSAGE_ALL,
        ACTION_BAR,
        LEGACY;

    }

    public static class Builder {
        private EventDisplayType eventDisplayType = EventDisplayType.NONE;
        private Set<EventTag> eventTags = new HashSet<EventTag>();
        private TextComponent eventMessage;
        private TextColor nameColor = TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE);
        private List<VaultEventTask> eventTasks = new ArrayList<VaultEventTask>();

        public Builder displayType(EventDisplayType type) {
            this.eventDisplayType = type;
            return this;
        }

        public Builder tag(EventTag tag) {
            this.eventTags.add(tag);
            return this;
        }

        public Builder message(TextComponent messsage) {
            this.eventMessage = messsage;
            return this;
        }

        public Builder color(TextColor color) {
            this.nameColor = color;
            return this;
        }

        public Builder task(VaultEventTask task) {
            this.eventTasks.add(task);
            return this;
        }

        public VaultEvent build(String eventName, TextComponent eventDescription) {
            if (this.eventMessage == null) {
                this.eventMessage = new TextComponent("");
            }
            return new VaultEvent(eventName, this.eventMessage, this.nameColor, eventDescription, this.eventDisplayType, this.eventTags, this.eventTasks);
        }
    }
}

