/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks;

import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xyz.iwolfking.woldsvaults.api.core.vault_events.lib.VaultEventTask;

public class BlockConversionTask
implements VaultEventTask {
    private final Predicate<Block> blockPredicate;
    private final WeightedList<BlockState> replacementBlocks;
    private final int searchRadius;

    public BlockConversionTask(Predicate<Block> blockPredicate, WeightedList<BlockState> replacementBlocks, int searchRadius) {
        this.blockPredicate = blockPredicate;
        this.replacementBlocks = replacementBlocks;
        this.searchRadius = searchRadius;
    }

    @Override
    public void performTask(Supplier<BlockPos> pos, ServerPlayer player, Vault vault) {
        ServerLevel level = player.m_183503_();
        ArrayList<BlockPos> foundBlocks = new ArrayList<BlockPos>();
        for (int x = -this.searchRadius; x <= this.searchRadius; ++x) {
            for (int y = -this.searchRadius; y <= this.searchRadius; ++y) {
                for (int z = -this.searchRadius; z <= this.searchRadius; ++z) {
                    BlockPos currentPos = pos.get().m_142082_(x, y, z);
                    BlockState state = level.m_8055_(currentPos);
                    if (!this.blockPredicate.test(state.m_60734_())) continue;
                    foundBlocks.add(currentPos);
                }
            }
        }
        for (BlockPos foundBlockPos : foundBlocks) {
            BlockEntity blockEntity;
            BlockState replacementBlock = this.replacementBlocks.getRandom().orElse(Blocks.f_50016_.m_49966_());
            level.m_7731_(foundBlockPos, this.replacementBlocks.getRandom().orElse(Blocks.f_50016_.m_49966_()), 3);
            if (replacementBlock.m_60734_() instanceof VaultChestBlock && (blockEntity = level.m_7702_(foundBlockPos)) instanceof VaultChestTileEntity) {
                VaultChestTileEntity vaultChestTileEntity = (VaultChestTileEntity)blockEntity;
                vaultChestTileEntity.setVaultChest(true);
                vaultChestTileEntity.generateChestLoot((Player)player, true);
            }
            if (!(replacementBlock.m_60734_() instanceof VaultOreBlock)) continue;
            BlockState oreState = level.m_8055_(foundBlockPos);
            oreState.m_61124_((Property)VaultOreBlock.GENERATED, (Comparable)Boolean.valueOf(true));
            oreState.m_61124_((Property)VaultOreBlock.TYPE, (Comparable)VaultOreBlock.Type.VAULT_STONE);
        }
    }

    public static class Builder {
        private final WeightedList<BlockState> blocks = new WeightedList();
        private int searchRadius = 5;

        public Builder replacementBlock(BlockState state, double weight) {
            this.blocks.add((Object)state, Double.valueOf(weight));
            return this;
        }

        public Builder searchRadius(int searchRadius) {
            this.searchRadius = searchRadius;
            return this;
        }

        public BlockConversionTask build(Predicate<Block> blockPredicate) {
            if (this.blocks.isEmpty()) {
                this.blocks.add((Object)Blocks.f_50016_.m_49966_(), Double.valueOf(1.0));
            }
            return new BlockConversionTask(blockPredicate, this.blocks, this.searchRadius);
        }
    }
}

