/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import xyz.iwolfking.woldsvaults.api.core.vault_events.VaultEvent;
import xyz.iwolfking.woldsvaults.api.core.vault_events.lib.VaultEventTask;

public class MessageTask
implements VaultEventTask {
    private final VaultEvent.EventDisplayType displayType;
    private final TextComponent message;

    public MessageTask(VaultEvent.EventDisplayType displayType, TextComponent message) {
        this.displayType = displayType;
        this.message = message;
    }

    @Override
    public void performTask(Supplier<BlockPos> pos, ServerPlayer player, Vault vault) {
        this.sendEventMessages(vault, player);
    }

    public void sendEventMessages(Vault vault, ServerPlayer originator) {
        switch (this.displayType) {
            case NONE: {
                return;
            }
            case ACTION_BAR: {
                this.handleActionBarMessage(originator);
                break;
            }
            case CHAT_MESSAGE_TARGET: {
                this.handleChatMessage(originator, vault, false);
                break;
            }
            case CHAT_MESSAGE_ALL: {
                this.handleChatMessage(originator, vault, true);
                break;
            }
            default: {
                this.handleLegacyEventMessage(originator, vault);
            }
        }
    }

    public void handleActionBarMessage(ServerPlayer player) {
        player.m_5661_((Component)this.message, true);
    }

    public void handleChatMessage(ServerPlayer target, Vault vault, boolean shouldSendAll) {
        if (this.displayType.equals((Object)VaultEvent.EventDisplayType.CHAT_MESSAGE_TARGET)) {
            target.m_5661_((Component)this.message, false);
            return;
        }
        for (Listener listener : ((Listeners)vault.get(Vault.LISTENERS)).getAll()) {
            listener.getPlayer().ifPresent(other -> {
                target.f_19853_.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
                other.m_5661_((Component)this.message, false);
            });
        }
    }

    public void handleLegacyEventMessage(ServerPlayer target, Vault vault) {
    }
}

