/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks;

import iskallia.vault.core.vault.Vault;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import xyz.iwolfking.woldsvaults.api.core.vault_events.lib.VaultEventTask;
import xyz.iwolfking.woldsvaults.api.util.ref.Effect;

public class PlayerMobEffectTask
implements VaultEventTask {
    private final List<Effect> effects;

    public PlayerMobEffectTask(List<Effect> effects) {
        this.effects = effects;
    }

    @Override
    public void performTask(Supplier<BlockPos> pos, ServerPlayer player, Vault vault) {
        for (Effect effect : this.effects) {
            effect.apply((LivingEntity)player);
        }
    }

    public static class Builder {
        private final List<Effect> effects = new ArrayList<Effect>();

        public Builder effect(MobEffect effect, int amplitude, int duration) {
            this.effects.add(new Effect(effect, amplitude, duration));
            return this;
        }

        public PlayerMobEffectTask build() {
            if (this.effects.isEmpty()) {
                this.effects.add(new Effect(MobEffects.f_19601_, 0, 20));
            }
            return new PlayerMobEffectTask(this.effects);
        }
    }
}

