/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.core.vault_events.impl.tasks;

import com.github.alexthe666.alexsmobs.entity.EntityCockroach;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import xyz.iwolfking.woldsvaults.WoldsVaults;
import xyz.iwolfking.woldsvaults.api.core.vault_events.lib.VaultEventTask;
import xyz.iwolfking.woldsvaults.api.util.ref.Effect;

public class SpawnMobTask
implements VaultEventTask {
    private final WeightedList<EntityType<?>> entities;
    private final WeightedList<Integer> amounts;
    private final WeightedList<Effect> effects;
    private final ItemStack heldStack;
    private final double minSpawnRange;
    private final double maxSpawnRange;

    public SpawnMobTask(WeightedList<EntityType<?>> entities, WeightedList<Integer> amounts, WeightedList<Effect> effects, ItemStack heldStack) {
        this.entities = entities;
        this.amounts = amounts;
        this.effects = effects;
        this.heldStack = heldStack;
        this.minSpawnRange = 10.0;
        this.maxSpawnRange = 13.0;
    }

    public SpawnMobTask(WeightedList<EntityType<?>> entities, WeightedList<Integer> amounts, WeightedList<Effect> effects, ItemStack heldStack, double minSpawnRange, double maxSpawnRange) {
        this.entities = entities;
        this.amounts = amounts;
        this.effects = effects;
        this.heldStack = heldStack;
        this.minSpawnRange = minSpawnRange;
        this.maxSpawnRange = maxSpawnRange;
    }

    @Override
    public void performTask(Supplier<BlockPos> pos, ServerPlayer player, Vault vault) {
        JavaRandom javaRandom = JavaRandom.ofNanoTime();
        for (int i = 0; i < (Integer)this.amounts.getRandom().get(); ++i) {
            this.doSpawn((VirtualWorld)player.f_19853_, pos.get(), (RandomSource)javaRandom);
        }
    }

    public Entity doSpawn(VirtualWorld world, BlockPos pos, RandomSource random) {
        double min = this.minSpawnRange;
        double max = this.maxSpawnRange;
        Entity spawned = null;
        int attempts = 0;
        int maxAttempts = 50;
        while (spawned == null && attempts++ < maxAttempts) {
            double angle = Math.PI * 2 * random.nextDouble();
            double distance = Math.sqrt(random.nextDouble() * (max * max - min * min) + min * min);
            int x = (int)Math.ceil(distance * Math.cos(angle));
            int z = (int)Math.ceil(distance * Math.sin(angle));
            double xzRadius = Math.sqrt(x * x + z * z);
            double yRange = Math.sqrt(max * max - xzRadius * xzRadius);
            int y = random.nextInt((int)Math.ceil(yRange) * 2 + 1) - (int)Math.ceil(yRange);
            spawned = this.spawnMob(world, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z, random);
        }
        if (spawned == null) {
            WoldsVaults.LOGGER.warn("Failed to spawn mob after {} attempts at {} in {}", new Object[]{maxAttempts, pos, world.m_6018_().m_46472_()});
        }
        return spawned;
    }

    @Nullable
    public Entity spawnMob(VirtualWorld world, int x, int y, int z, RandomSource random) {
        EntityType type = null;
        if (this.entities.getRandom().isPresent()) {
            type = (EntityType)this.entities.getRandom().get();
        }
        Entity entity = type != null ? type.m_20615_((Level)world) : null;
        BlockState state = world.m_8055_(new BlockPos(x, y - 1, z));
        if (entity == null || !state.m_60643_((BlockGetter)world, new BlockPos(x, y - 1, z), entity.m_6095_())) {
            return null;
        }
        AABB entityBox = entity.m_6095_().m_20585_((double)x + 0.5, (double)y, (double)z + 0.5);
        if (!world.m_45772_(entityBox)) {
            return null;
        }
        entity.m_7678_((double)((float)x + 0.5f), (double)((float)y + 0.2f), (double)((float)z + 0.5f), (float)(random.nextDouble() * 2.0 * Math.PI), 0.0f);
        if (!this.heldStack.equals(ItemStack.f_41583_)) {
            if (entity instanceof EntityCockroach) {
                EntityCockroach roach = (EntityCockroach)entity;
                roach.setMaracas(true);
            } else {
                entity.m_8061_(EquipmentSlot.MAINHAND, this.heldStack);
            }
        }
        if (!this.effects.isEmpty()) {
            this.effects.forEach((mobEffectInstance, aDouble) -> {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    mobEffectInstance.apply(livingEntity);
                }
            });
        }
        world.m_8847_(entity);
        return entity;
    }

    public static class Builder {
        private final WeightedList<EntityType<?>> entities = new WeightedList();
        private final WeightedList<Integer> amounts = new WeightedList();
        private final WeightedList<Effect> effects = new WeightedList();
        private ItemStack heldStack = ItemStack.f_41583_;
        private double minSpawnRange = 10.0;
        private double maxSpawnRange = 13.0;

        public Builder entity(EntityType<?> type, double weight) {
            this.entities.add(type, Double.valueOf(weight));
            return this;
        }

        public Builder amount(Integer amount, double weight) {
            this.amounts.add((Object)amount, Double.valueOf(weight));
            return this;
        }

        public Builder effect(Effect effect, double weight) {
            this.effects.add((Object)effect, Double.valueOf(weight));
            return this;
        }

        public Builder heldStack(ItemStack stack) {
            this.heldStack = stack;
            return this;
        }

        public Builder spawnRanges(double minSpawnRange, double maxSpawnRange) {
            this.minSpawnRange = minSpawnRange;
            this.maxSpawnRange = maxSpawnRange;
            return this;
        }

        public SpawnMobTask build() {
            if (this.entities.isEmpty()) {
                this.entities.add((Object)EntityType.f_20549_, Double.valueOf(1.0));
            }
            if (this.amounts.isEmpty()) {
                this.amounts.add((Object)1, Double.valueOf(1.0));
            }
            return new SpawnMobTask(this.entities, this.amounts, this.effects, this.heldStack, this.minSpawnRange, this.maxSpawnRange);
        }
    }
}

