/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.lib.trinket;

import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.trinket.GearAttributeTrinket;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class MultiAttributeTrinket<T extends Number>
extends TrinketEffect<Config<?>>
implements GearAttributeTrinket {
    private final List<VaultGearAttribute<T>> defaultAttribute;
    private final List<T> defaultAttributeValue;

    public MultiAttributeTrinket(ResourceLocation name, List<VaultGearAttribute<T>> defaultAttribute, List<T> defaultAttributeValue) {
        super(name);
        this.defaultAttribute = defaultAttribute;
        this.defaultAttributeValue = defaultAttributeValue;
    }

    public Class<Config<?>> getConfigClass() {
        return MiscUtils.cast(Config.class);
    }

    public Config<T> getDefaultConfig() {
        return new Config<T>(this.defaultAttribute, this.defaultAttributeValue);
    }

    public List<VaultGearAttributeInstance<?>> getAttributes() {
        return ((Config)this.getConfig()).toAttributeInstances();
    }

    public static class Config<T extends Number>
    extends TrinketEffect.Config {
        @Expose
        private final List<ResourceLocation> keys = new ArrayList<ResourceLocation>();
        @Expose
        private final List<Number> values = new ArrayList<Number>();

        public Config(List<VaultGearAttribute<T>> attributes, List<T> values) {
            for (VaultGearAttribute<T> attribute : attributes) {
                this.keys.add(attribute.getRegistryName());
            }
            this.values.addAll(values);
        }

        public List<VaultGearAttribute<T>> getAttributes() {
            ArrayList<VaultGearAttribute<T>> attributes = new ArrayList<VaultGearAttribute<T>>();
            for (ResourceLocation key : this.keys) {
                attributes.add(VaultGearAttributeRegistry.getAttribute((ResourceLocation)key));
            }
            return attributes;
        }

        public List<VaultGearAttributeInstance<?>> toAttributeInstances() {
            ArrayList instances = new ArrayList();
            List<VaultGearAttribute<T>> attributes = this.getAttributes();
            for (int i = 0; i < attributes.size(); ++i) {
                instances.add(VaultGearAttributeInstance.cast(attributes.get(i), (Object)this.values.get(i)));
            }
            return instances;
        }
    }
}

