/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.util;

import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ChainingParticleMessage;
import iskallia.vault.network.message.EffectMessage;
import iskallia.vault.util.BlockBreakHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

public abstract class ChainBreakHandler
extends BlockBreakHandler {
    private static final List<IItemDamageHandler> DAMAGE_HANDLER_LIST = new ArrayList<IItemDamageHandler>(){};

    private static IItemDamageHandler getDamageHandler(ItemStack itemStack) {
        for (IItemDamageHandler handler : DAMAGE_HANDLER_LIST) {
            if (!handler.matches(itemStack)) continue;
            return handler;
        }
        return DefaultItemDamageHandler.INSTANCE;
    }

    protected abstract int getRange();

    public boolean areaDig(ServerLevel level, ServerPlayer player, BlockPos pos, Block targetBlock) {
        if (targetBlock == Blocks.f_50016_) {
            return false;
        }
        if (!level.m_8055_(pos).canHarvestBlock((BlockGetter)level, pos, (Player)player)) {
            return false;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41763_()) {
            VaultGearItem gearItem;
            Item item = heldItem.m_41720_();
            if (item instanceof VaultGearItem && (gearItem = (VaultGearItem)item).isBroken(heldItem)) {
                return false;
            }
            int usesLeft = heldItem.m_41776_() - heldItem.m_41773_();
            if (usesLeft <= 1) {
                return false;
            }
        }
        IItemDamageHandler damageHandler = ChainBreakHandler.getDamageHandler(heldItem);
        int limit = this.getBlockLimit((Player)player);
        int range = this.getRange();
        if (limit == 1) {
            this.destroyBlock(level, player, heldItem, damageHandler, pos, this.shouldVoid(level, player, level.m_8055_(pos)), false);
            return true;
        }
        if (limit <= 0) {
            return false;
        }
        boolean showChain = range > 1;
        boolean heldItemStartedEmpty = heldItem.m_41619_();
        HashSet<BlockPos> traversedBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> positionQueue = new LinkedList<BlockPos>();
        positionQueue.add(pos);
        block0: while (!positionQueue.isEmpty()) {
            BlockPos headPos = (BlockPos)positionQueue.poll();
            for (BlockPos offset : BlockPos.m_121985_((BlockPos)headPos, (int)range, (int)range, (int)range).map(BlockPos::m_7949_).toList()) {
                VaultGearItem gearItem;
                Item item;
                BlockState blockState;
                if (traversedBlocks.size() >= limit) {
                    positionQueue.clear();
                    continue block0;
                }
                if (traversedBlocks.contains(offset) || (blockState = level.m_8055_(offset)).m_60795_() || blockState.m_60734_() != targetBlock) continue;
                this.destroyBlock(level, player, heldItem, damageHandler, offset, this.shouldVoid(level, player, blockState), !offset.equals((Object)pos));
                if (heldItem.m_41619_() && !heldItemStartedEmpty || (item = heldItem.m_41720_()) instanceof VaultGearItem && (gearItem = (VaultGearItem)item).isBroken(heldItem)) {
                    positionQueue.clear();
                    continue block0;
                }
                if (showChain) {
                    ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ChainingParticleMessage(List.of(Vec3.m_82512_((Vec3i)headPos), Vec3.m_82512_((Vec3i)offset))));
                }
                positionQueue.add(offset);
                traversedBlocks.add(offset);
            }
        }
        return true;
    }

    private void destroyBlock(ServerLevel level, ServerPlayer player, ItemStack mainHandItem, IItemDamageHandler damageHandler, BlockPos pos, boolean shouldVoid, boolean playBreakParticles) {
        GameType gameModeForPlayer = player.f_8941_.m_9290_();
        BlockState blockstate = level.m_8055_(pos);
        int experience = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)gameModeForPlayer, (ServerPlayer)player, (BlockPos)pos);
        if (experience != -1) {
            BlockEntity blockentity = level.m_7702_(pos);
            Block block = blockstate.m_60734_();
            if (block instanceof GameMasterBlock && !player.m_36337_()) {
                level.m_7260_(pos, blockstate, blockstate, 3);
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockstate));
            } else if (!mainHandItem.onBlockStartBreak(pos, (Player)player) && !player.m_36187_((Level)level, pos, gameModeForPlayer)) {
                boolean canHarvestBlock;
                if (player.f_8941_.m_9295_()) {
                    this.removeBlock(level, player, pos, false);
                    return;
                }
                ItemStack mainHandItemProxy = this.getMiningItemProxy((Player)player);
                mainHandItemProxy.m_41686_((Level)level, blockstate, pos, (Player)player);
                if (mainHandItemProxy.m_41619_() && !mainHandItem.m_41619_()) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)mainHandItem, (InteractionHand)InteractionHand.MAIN_HAND);
                    mainHandItem.m_41774_(1);
                } else if (damageHandler.wasDamaged(mainHandItem, mainHandItemProxy)) {
                    damageHandler.applyDamage(mainHandItem, mainHandItemProxy);
                }
                boolean bl = canHarvestBlock = blockstate.canHarvestBlock((BlockGetter)level, pos, (Player)player) && !shouldVoid;
                if (this.removeBlock(level, player, pos, canHarvestBlock)) {
                    if (canHarvestBlock) {
                        block.m_6240_((Level)level, (Player)player, pos, blockstate, blockentity, mainHandItemProxy);
                    }
                    if (experience > 0) {
                        block.m_49805_(level, pos, experience);
                    }
                    if (playBreakParticles) {
                        EffectMessage msg = new EffectMessage(EffectMessage.Type.BLOCK_BREAK_EFFECT, Vec3.m_82528_((Vec3i)pos));
                        msg.addData(buf -> buf.writeInt(Block.m_49956_((BlockState)blockstate)));
                        ModNetwork.CHANNEL.sendTo((Object)msg, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                    }
                }
            }
        }
    }

    private boolean removeBlock(ServerLevel level, ServerPlayer player, BlockPos pos, boolean canHarvest) {
        FluidState fluid;
        BlockState blockState = level.m_8055_(pos);
        boolean removed = blockState.onDestroyedByPlayer((Level)level, pos, (Player)player, canHarvest, fluid = this.hasHydroVoid(player) ? Fluids.f_76191_.m_76145_() : level.m_6425_(pos));
        if (removed) {
            blockState.m_60734_().m_6786_((LevelAccessor)level, pos, blockState);
        }
        return removed;
    }

    private boolean hasHydroVoid(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != ModItems.TOOL) {
            return false;
        }
        VaultGearData data = VaultGearData.read((ItemStack)stack);
        return (Boolean)data.get(ModGearAttributes.HYDROVOID, VaultGearAttributeTypeMerger.anyTrue());
    }

    private static interface IItemDamageHandler {
        public boolean matches(ItemStack var1);

        public boolean wasDamaged(ItemStack var1, ItemStack var2);

        public void applyDamage(ItemStack var1, ItemStack var2);
    }

    private static class DefaultItemDamageHandler
    implements IItemDamageHandler {
        public static final IItemDamageHandler INSTANCE = new DefaultItemDamageHandler();

        private DefaultItemDamageHandler() {
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return true;
        }

        @Override
        public boolean wasDamaged(ItemStack itemStack, ItemStack proxy) {
            return itemStack.m_41773_() != proxy.m_41773_();
        }

        @Override
        public void applyDamage(ItemStack itemStack, ItemStack proxy) {
            itemStack.m_41721_(proxy.m_41773_());
        }
    }
}

