/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.util;

import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.util.TextComponentUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import xyz.iwolfking.woldsvaults.api.util.ColorUtil;

public class ComponentUtils {
    public static MutableComponent corruptComponent(MutableComponent cmp) {
        int randomOffset;
        Random rand = new Random(cmp.getString().hashCode());
        Style corruptColor = Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAD0000));
        int cmpLength = TextComponentUtils.getLength((Component)cmp);
        if (cmpLength == 0) {
            return new TextComponent("").m_7220_((Component)cmp);
        }
        int time = (int)((double)cmpLength * 2.2);
        int baseStep = (int)(System.currentTimeMillis() / 200L % (long)time);
        int step = (baseStep + (randomOffset = rand.nextInt(Math.max(1, cmpLength / 2)))) % cmpLength;
        if (step >= cmpLength) {
            return new TextComponent("").m_7220_((Component)cmp);
        }
        List indices = IntStream.range(0, cmpLength).boxed().collect(Collectors.toList());
        Collections.shuffle(indices, rand);
        step = (Integer)indices.get(step);
        CommandSourceStack stack = TextComponentUtils.createClientSourceStack();
        MutableComponent startCmp = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)0, (int)step);
        MutableComponent highlight = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)step, (int)Math.min(step + 1, cmpLength));
        MutableComponent endCmp = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)(step + 1));
        TextComponentUtils.applyStyle((Component)highlight, (Style)corruptColor.m_178524_(Boolean.valueOf(true)));
        return new TextComponent("").m_7220_((Component)startCmp).m_7220_((Component)highlight).m_7220_((Component)endCmp);
    }

    public static MutableComponent corruptComponentServerSide(MutableComponent cmp) {
        int randomOffset;
        Random rand = new Random(cmp.getString().hashCode());
        Style corruptColor = Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAD0000));
        int cmpLength = TextComponentUtils.getLength((Component)cmp);
        if (cmpLength == 0) {
            return new TextComponent("").m_7220_((Component)cmp);
        }
        int time = (int)((double)cmpLength * 2.2);
        int baseStep = (int)(System.currentTimeMillis() / 200L % (long)time);
        int step = (baseStep + (randomOffset = rand.nextInt(Math.max(1, cmpLength / 2)))) % cmpLength;
        if (step >= cmpLength) {
            return new TextComponent("").m_7220_((Component)cmp);
        }
        List indices = IntStream.range(0, cmpLength).boxed().collect(Collectors.toList());
        Collections.shuffle(indices, rand);
        step = (Integer)indices.get(step);
        CommandSourceStack stack = TextComponentUtils.createServerSourceStack();
        MutableComponent startCmp = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)0, (int)step);
        MutableComponent highlight = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)step, (int)Math.min(step + 1, cmpLength));
        MutableComponent endCmp = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)(step + 1));
        TextComponentUtils.applyStyle((Component)highlight, (Style)corruptColor.m_178524_(Boolean.valueOf(true)));
        return new TextComponent("").m_7220_((Component)startCmp).m_7220_((Component)highlight).m_7220_((Component)endCmp);
    }

    public static MutableComponent partiallyObfuscate(MutableComponent cmp, double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage must be between 0.0 and 1.0");
        }
        int cmpLength = TextComponentUtils.getLength((Component)cmp);
        if (cmpLength == 0) {
            return new TextComponent("").m_7220_((Component)cmp);
        }
        int charsToObfuscate = (int)Math.round((double)cmpLength * percentage);
        if (charsToObfuscate == 0) {
            return new TextComponent("").m_7220_((Component)cmp);
        }
        Random random = new Random(cmp.getString().hashCode());
        List indices = IntStream.range(0, cmpLength).boxed().collect(Collectors.toList());
        Collections.shuffle(indices, random);
        Set obfuscateIndices = indices.stream().limit(charsToObfuscate).collect(Collectors.toSet());
        CommandSourceStack stack = TextComponentUtils.createClientSourceStack();
        TextComponent result = new TextComponent("");
        for (int i = 0; i < cmpLength; ++i) {
            MutableComponent charComponent = TextComponentUtils.substring((CommandSourceStack)stack, (Component)cmp, (int)i, (int)(i + 1));
            if (obfuscateIndices.contains(i)) {
                TextComponentUtils.applyStyle((Component)charComponent, (Style)charComponent.m_7383_().m_178524_(Boolean.valueOf(true)));
            }
            result.m_7220_((Component)charComponent);
        }
        return result;
    }

    public static MutableComponent wavingComponent(MutableComponent base, TextColor baseColor, float frequency, float amplitude) {
        return ComponentUtils.wavingComponent(base, baseColor.m_131265_(), frequency, amplitude);
    }

    public static MutableComponent wavingComponent(MutableComponent base, int color, float frequency, float amplitude) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return base;
        }
        String text = base.getString();
        TextComponent result = new TextComponent("");
        float time = ClientScheduler.INSTANCE.getTick();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            float wave = (float)Math.sin((time - (float)i) * frequency) * amplitude + 1.0f;
            result.m_7220_((Component)new TextComponent(String.valueOf(c)).m_130948_(base.m_7383_().m_178520_(ColorUtil.brightenColor(color, wave))));
        }
        return result;
    }
}

