/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.LightmapHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.iwolfking.woldsvaults.api.util.ComponentUtils;
import xyz.iwolfking.woldsvaults.api.util.CorruptedVaultHelper;
import xyz.iwolfking.woldsvaults.objectives.CorruptedObjective;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CorruptedVaultClientHelper {
    private static final ResourceLocation VIGNETTE = VaultMod.id((String)"textures/gui/vignette.png");
    private static final ResourceLocation CORRUPTED_HUD = VaultMod.id((String)"textures/gui/corrupted/hud.png");

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void corruptTooltips(ItemTooltipEvent event) {
        if (!CorruptedVaultHelper.isVaultCorrupted) {
            return;
        }
        List toolTip = event.getToolTip();
        for (int i = 0; i < toolTip.size(); ++i) {
            Object e = toolTip.get(i);
            if (!(e instanceof MutableComponent)) continue;
            MutableComponent cmp = (MutableComponent)e;
            toolTip.set(i, ComponentUtils.corruptComponent(cmp));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderVignette(TextColor color, float alpha, int width, int height, ResourceLocation vignette) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int colorValue = color.m_131265_();
        float b = (float)(colorValue & 0xFF) / 255.0f;
        float g = (float)(colorValue >> 8 & 0xFF) / 255.0f;
        float r = (float)(colorValue >> 16 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)vignette);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)height, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, (double)height, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        RenderSystem.m_69453_();
    }

    public static void renderObjectiveProgress(CorruptedObjective obj, PoseStack poseStack, Font font, int centerX) {
        int current = (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.COUNT);
        int total = (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.TARGET);
        MutableComponent progressText = new TextComponent(String.valueOf(current)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)new TextComponent(" / ").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_7220_((Component)new TextComponent(String.valueOf(total)).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD}));
        float progress = (float)current / (float)total;
        poseStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTex = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CORRUPTED_HUD);
        poseStack.m_85837_((double)(centerX - 80), 8.0, 0.0);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)100);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)0, (int)8, (float)0.0f, (float)30.0f, (int)(13 + (int)(130.0f * progress)), (int)10, (int)200, (int)100);
        RenderSystem.m_157453_((int)0, (int)previousTex);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        float x = (float)centerX / 0.6f - (float)font.m_92852_((FormattedText)progressText) / 2.0f;
        Objects.requireNonNull(font);
        float y = 9 + 22;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_92733_(progressText.m_7532_(), x, y, -1, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        poseStack.m_85849_();
    }

    public static void renderCorruptionOverlay(CorruptedObjective obj, PoseStack poseStack, Font font, Window window, int centerX) {
        float corruption = ((Float)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.CORRUPTION)).floatValue();
        float clamped = Math.min(corruption, 10.0f);
        float shakeAmount = 0.2f + 1.75f * (clamped / 10.0f);
        int r = (int)(255.0f + -75.0f * (clamped / 10.0f));
        int g = (int)(255.0f + -255.0f * (clamped / 10.0f));
        int b = (int)(255.0f + -255.0f * (clamped / 10.0f));
        TextColor color = TextColor.m_131266_((int)(r << 16 | g << 8 | b));
        boolean roofDisplay = (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.COUNT) >= (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.TARGET) && (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.TIME_TICKED_FAKE) == 401;
        String format = roofDisplay ? "???" : String.format("%.1f", Float.valueOf(corruption * 100.0f)) + "%";
        MutableComponent text = new TextComponent(format).m_130948_(Style.f_131099_.m_131148_(color));
        CorruptedVaultClientHelper.renderShakingText(poseStack, text, centerX - font.m_92852_((FormattedText)text) / 2, 44, shakeAmount);
        CorruptedVaultClientHelper.renderVignette(TextColor.m_131268_((String)"#fa0000"), Mth.m_14036_((float)(corruption / 35.0f), (float)0.0f, (float)0.5f), window.m_85445_(), window.m_85446_(), VIGNETTE);
    }

    public static void renderShakingText(PoseStack matrixStack, MutableComponent text, int x, int y, float intensity) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        if (mc.f_91073_ == null) {
            return;
        }
        matrixStack.m_85836_();
        float effectiveIntensity = Math.min(intensity, 1.3f);
        float shakeX = (mc.f_91073_.f_46441_.nextFloat() - 0.5f) * 2.0f * effectiveIntensity;
        float shakeY = (mc.f_91073_.f_46441_.nextFloat() - 0.5f) * 2.0f * effectiveIntensity;
        matrixStack.m_85837_((double)shakeX, (double)shakeY, 0.0);
        int layers = (int)(1.0f + intensity * 2.0f);
        for (int i = 0; i < layers; ++i) {
            float offsetX = (mc.f_91073_.f_46441_.nextFloat() - 0.5f) * effectiveIntensity * 0.5f;
            float offsetY = (mc.f_91073_.f_46441_.nextFloat() - 0.5f) * effectiveIntensity * 0.5f;
            font.m_92763_(matrixStack, (Component)text, (float)x + offsetX, (float)y + offsetY, 0xFFFFFF);
        }
        matrixStack.m_85849_();
    }

    public static void renderTimeAddendOverlay(CorruptedObjective obj, PoseStack poseStack, Window window, Player player) {
        if ((Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.DISPLAY_OVERLAY_TICK) > 0 && player != null) {
            float alpha = Math.min(1.0f, (float)((Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.DISPLAY_OVERLAY_TICK)).intValue() / 40.0f);
            int textColor = (int)(255.0f * alpha) << 24 | 0xFFFFFF;
            float time = (float)((Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.TIME_ADDEND_TICKS)).intValue() / 20.0f;
            TextComponent text = new TextComponent("+" + time + "s");
            FontHelper.drawStringWithBorder((PoseStack)poseStack, (Component)text, (float)76.0f, (float)(window.m_85446_() - 44), (int)textColor, (int)-16777216);
        }
    }

    public static void renderEscapePrompt(CorruptedObjective obj, PoseStack poseStack, Font font, int centerX) {
        MutableComponent msg1 = new TextComponent("Find an escape.").m_130940_(ChatFormatting.RED);
        MutableComponent msg2 = new TextComponent("?? / " + ((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.SECONDARY_TARGET)).m_130940_(ChatFormatting.RED);
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_92733_(msg1.m_7532_(), (float)centerX - (float)font.m_92852_((FormattedText)msg1) / 2.0f, 9.0f, -1, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        font.m_92733_(msg2.m_7532_(), (float)centerX - (float)font.m_92852_((FormattedText)msg2) / 2.0f, 21.0f, -1, true, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
    }
}

