/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.util;

import iskallia.vault.VaultMod;
import iskallia.vault.block.ObeliskBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.PaletteKey;
import iskallia.vault.core.data.key.TemplatePoolKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.event.common.TemplateGenerationEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.PortalData;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.KillBossObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.TickTimer;
import iskallia.vault.core.vault.time.modifier.ClockModifier;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.generator.layout.ClassicInfiniteLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.Palette;
import iskallia.vault.core.world.storage.IZonedWorld;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.EmptyTemplate;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.entity.entity.bloodhorde.Tier5BloodHordeEntity;
import iskallia.vault.entity.entity.bloodmoon.Tier5BloodSkeletonEntity;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.MonolithIgniteMessage;
import iskallia.vault.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.woldsvaults.api.util.ComponentUtils;
import xyz.iwolfking.woldsvaults.blocks.MonolithControllerBlock;
import xyz.iwolfking.woldsvaults.blocks.tiles.FracturedObeliskTileEntity;
import xyz.iwolfking.woldsvaults.data.compound.FloatList;
import xyz.iwolfking.woldsvaults.events.vaultevents.WoldCommonEvents;
import xyz.iwolfking.woldsvaults.init.ModBlocks;
import xyz.iwolfking.woldsvaults.init.ModItems;
import xyz.iwolfking.woldsvaults.items.LocatorItem;
import xyz.iwolfking.woldsvaults.modifiers.clock.KillMobTimeExtension;
import xyz.iwolfking.woldsvaults.objectives.CorruptedObjective;

public class CorruptedVaultHelper {
    private static final UUID HEALTH_REDUCTION_UUID = UUID.fromString("24edf251-5c02-4acb-9eff-8896bc140916");
    public static boolean isVaultCorrupted = false;

    public static void generateSlash(VirtualWorld world, BlockPos start) {
        int taperedWidth;
        Vec3 pos;
        int i;
        Random random = world.m_5822_();
        float angle = random.nextFloat() * ((float)Math.PI * 2);
        float angleDelta = (random.nextFloat() - 0.5f) * 0.05f;
        double px = (double)start.m_123341_() + 0.5;
        double pz = (double)start.m_123343_() + 0.5;
        int length = 30 + random.nextInt(20);
        int baseWidth = 2 + random.nextInt(2);
        ArrayList<Vec3> slashPath = new ArrayList<Vec3>();
        for (int i2 = 0; i2 < length; ++i2) {
            slashPath.add(new Vec3(px, 64.0, pz));
            double dx = Math.cos(angle += angleDelta);
            double dz = Math.sin(angle);
            px += dx;
            pz += dz;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (i = 0; i < slashPath.size(); ++i) {
            pos = (Vec3)slashPath.get(i);
            float taper = (float)Math.sin(Math.PI * (double)i / (double)length);
            taperedWidth = Math.max(1, Math.round((float)baseWidth * taper));
            int outerWidth = taperedWidth + 1;
            for (int x = -outerWidth; x <= outerWidth; ++x) {
                for (int z = -outerWidth; z <= outerWidth; ++z) {
                    double dist = x * x + z * z;
                    if (!(dist <= (double)(outerWidth * outerWidth) + 0.2)) continue;
                    for (int y = 63; y >= 0; --y) {
                        mutable.m_122169_((double)(Math.round(pos.m_7096_()) + (long)x), (double)y, (double)(Math.round(pos.m_7094_()) + (long)z));
                        if (world.m_8055_((BlockPos)mutable).m_60713_((Block)iskallia.vault.init.ModBlocks.VAULT_BEDROCK) || !world.m_46749_((BlockPos)mutable)) continue;
                        world.m_7731_((BlockPos)mutable, iskallia.vault.init.ModBlocks.VAULT_BEDROCK.m_49966_(), 3);
                    }
                }
            }
        }
        for (i = 0; i < slashPath.size(); ++i) {
            pos = (Vec3)slashPath.get(i);
            float taper = 1.0f - Math.abs(((float)i - (float)length / 2.0f) / ((float)length / 2.0f));
            taperedWidth = Math.max(1, Math.round((float)baseWidth * taper));
            for (int x = -taperedWidth; x <= taperedWidth; ++x) {
                for (int z = -taperedWidth; z <= taperedWidth; ++z) {
                    double dist = x * x + z * z;
                    if (!(dist <= (double)(taperedWidth * taperedWidth) + 0.2)) continue;
                    for (int y = 63; y >= 0; --y) {
                        mutable.m_122169_((double)(Math.round(pos.m_7096_()) + (long)x), (double)y, (double)(Math.round(pos.m_7094_()) + (long)z));
                        if (!world.m_8055_((BlockPos)mutable).m_60767_().m_76333_() || !world.m_46749_((BlockPos)mutable)) continue;
                        world.m_7731_((BlockPos)mutable, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
        }
    }

    public static void spawnSpike(VirtualWorld world, BlockPos center, Random random, Player player) {
        Block[] possibleBlocks = new Block[]{iskallia.vault.init.ModBlocks.ERROR_BLOCK, Blocks.f_50080_, Blocks.f_50723_, iskallia.vault.init.ModBlocks.VAULT_STONE};
        int baseRadius = 2 + random.nextInt(2);
        int spikeCount = 4 + random.nextInt(3);
        for (int dx = -baseRadius; dx <= baseRadius; ++dx) {
            for (int dz = -baseRadius; dz <= baseRadius; ++dz) {
                BlockPos pos;
                if (dx * dx + dz * dz > baseRadius * baseRadius + random.nextInt(2) || !world.m_46859_(pos = center.m_142082_(dx, 0, dz)) || pos.m_123331_((Vec3i)player.m_142538_()) < 3.0) continue;
                Block blockType = possibleBlocks[random.nextInt(possibleBlocks.length)];
                world.m_7731_(pos, blockType.m_49966_(), 3);
            }
        }
        for (int i = 0; i < spikeCount; ++i) {
            int spikeHeight = 6 + random.nextInt(8);
            int xOffset = random.nextInt(5) - 2;
            int zOffset = random.nextInt(5) - 2;
            BlockPos start = center.m_142082_(xOffset, 1, zOffset);
            int thickness = 2;
            for (int h = 0; h < spikeHeight; ++h) {
                BlockPos current = start.m_6630_(h).m_142082_(xOffset * h / 5, 0, zOffset * h / 5);
                for (int dx = -thickness; dx <= thickness; ++dx) {
                    for (int dz = -thickness; dz <= thickness; ++dz) {
                        BlockPos pos;
                        if (Math.abs(dx) + Math.abs(dz) > thickness || !world.m_46859_(pos = current.m_142082_(dx, 0, dz)) || pos.m_123331_((Vec3i)player.m_142538_()) < 3.0) continue;
                        Block blockType = possibleBlocks[random.nextInt(possibleBlocks.length)];
                        world.m_7731_(pos, blockType.m_49966_(), 3);
                    }
                }
                if (h % 3 != 0 || thickness <= 0) continue;
                --thickness;
            }
        }
    }

    public static void fakeVictory(VirtualWorld world, Vault vault, Listener listener, CorruptedObjective objective) {
        int time = (Integer)((CorruptedObjective.CData)((Object)objective.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.TIME_TICKED_FAKE);
        listener.getPlayer().ifPresent(player -> {
            if (time == 0) {
                world.m_7967_((Entity)new FireworkRocketEntity((Level)world, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Items.f_42688_)));
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12496_, SoundSource.MASTER, 0.6f, 0.8f);
                TextComponent title = new TextComponent("Vault Completed!");
                title.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
                player.f_8906_.m_141995_((Packet)new ClientboundSetTitleTextPacket((Component)title));
            }
            if (time >= 100 && time < 320 && time % 5 == 0) {
                String jumbled = CorruptedVaultHelper.jumbleCharacters("Vault Completed!", world.f_46441_);
                MutableComponent corrupted = ComponentUtils.corruptComponentServerSide(new TextComponent(jumbled).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#870c03"))));
                player.f_8906_.m_141995_((Packet)new ClientboundSetTitleTextPacket((Component)corrupted));
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12170_, SoundSource.MASTER, 0.8f, 0.5f + world.f_46441_.nextFloat() * 0.5f);
            }
            if (time == 400) {
                world.m_7731_(new BlockPos(0, 63, 0), iskallia.vault.init.ModBlocks.ERROR_BLOCK.m_49966_(), 3);
                player.m_6021_(0.0, 64.0, 0.0);
                player.f_8906_.m_9774_(0.0, 64.0, 0.0, 0.0f, 0.0f);
                ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(VaultModifierRegistry.get((ResourceLocation)VaultMod.id((String)"crowded")), 10, true, (RandomSource)ChunkRandom.any());
                vault.ifPresent(Vault.CLOCK, clock -> clock.set(TickClock.VISIBLE));
                FloatingItemEntity floatingItem = FloatingItemEntity.create((Level)world, (BlockPos)new BlockPos(0, 65, 5), (ItemStack)new ItemStack((ItemLike)ModItems.OBELISK_RESONATOR));
                world.m_7967_((Entity)floatingItem);
                world.m_5594_(null, new BlockPos(0, 64, 0), SoundEvents.f_12377_, SoundSource.BLOCKS, 0.5f, 0.8f);
            }
        });
    }

    public static String jumbleCharacters(String input, Random random) {
        StringBuilder result = new StringBuilder(input);
        int length = input.length();
        int amountToModify = Math.max(1, (int)((double)length * (0.3 + random.nextDouble() * 0.2)));
        HashSet<Integer> indices = new HashSet<Integer>();
        while (indices.size() < amountToModify) {
            int index = random.nextInt(length);
            if (Character.isWhitespace(input.charAt(index))) continue;
            indices.add(index);
        }
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            boolean upper;
            int i = (Integer)iterator.next();
            char c = input.charAt(i);
            char replacement = Character.isDigit(c) ? (char)(48 + random.nextInt(10)) : (Character.isLetter(c) ? (char)(((upper = Character.isUpperCase(c)) ? 65 : 97) + random.nextInt(26)) : (char)(33 + random.nextInt(15)));
            result.setCharAt(i, replacement);
        }
        return result.toString();
    }

    public static boolean eligibleForExtraTime(Vault vault) {
        return (Integer)((TickClock)vault.get(Vault.CLOCK)).get(TickClock.DISPLAY_TIME) > 0;
    }

    public static void playActivationEffects(VirtualWorld world, BlockPos pos) {
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MonolithIgniteMessage(pos));
        world.m_5594_(null, pos, ModSounds.ARTIFACT_BOSS_CATALYST_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void spreadErrorBlocks(VirtualWorld world, BlockPos startPos) {
        int radius = 7;
        Random random = world.m_5822_();
        int centerX = startPos.m_123341_();
        int centerZ = startPos.m_123343_();
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                BlockPos currentPos;
                if (!(Math.pow(x - centerX, 2.0) + Math.pow(z - centerZ, 2.0) <= Math.pow(radius, 2.0)) || !world.m_8055_(currentPos = new BlockPos(x, startPos.m_123342_() - 1, z)).m_60804_((BlockGetter)world, currentPos) || !(random.nextFloat() >= 0.5f)) continue;
                if (random.nextFloat() >= 0.2f) {
                    world.m_7731_(currentPos, iskallia.vault.init.ModBlocks.ERROR_BLOCK.m_49966_(), 3);
                    continue;
                }
                world.m_7731_(currentPos, iskallia.vault.init.ModBlocks.VOID_LIQUID_BLOCK.m_49966_(), 3);
            }
        }
    }

    public static void handleObeliskBelow(BlockUseEvent.Data data, Vault vault, VirtualWorld world, BlockPos pos) {
        if (data.getWorld().m_7702_(pos) instanceof FracturedObeliskTileEntity) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            CorruptedVaultHelper.spreadErrorBlocks(world, pos);
            ItemStack stack = ModItems.RUINED_ESSENCE.m_7968_();
            stack.m_41784_().m_128362_("VaultID", (UUID)vault.get(Vault.ID));
            FloatingItemEntity floatingItem = FloatingItemEntity.create((Level)world, (BlockPos)pos.m_7494_(), (ItemStack)stack);
            world.m_7967_((Entity)floatingItem);
            data.setResult(InteractionResult.SUCCESS);
        }
    }

    public static void handleObeliskAbove(BlockUseEvent.Data data, VirtualWorld world, BlockPos pos, CorruptedObjective objective) {
        ((CorruptedObjective.CData)((Object)objective.get(CorruptedObjective.DATA))).set(CorruptedObjective.CData.SECONDARY_COUNT, (Integer)((CorruptedObjective.CData)((Object)objective.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.SECONDARY_COUNT) + 1);
        world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
        CorruptedVaultHelper.spawnSpike(world, pos.m_7495_(), world.f_46441_, data.getPlayer());
        if (((Integer)((CorruptedObjective.CData)((Object)objective.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.SECONDARY_COUNT)).intValue() == ((Integer)((CorruptedObjective.CData)((Object)objective.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.SECONDARY_TARGET)).intValue()) {
            ((CorruptedObjective.CData)((Object)objective.get(CorruptedObjective.DATA))).set(CorruptedObjective.CData.TRUE_COMPLETION, true);
        }
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        data.getPlayer().m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 1));
        int numEnemies = 20;
        int radius = 24;
        Random random = world.f_46441_;
        for (int i = 0; i < numEnemies; ++i) {
            Tier5BloodHordeEntity entity;
            int z;
            int y;
            double angle = Math.PI * 2 * (double)i / (double)numEnemies;
            int x = pos.m_123341_() + (int)(Math.cos(angle) * (double)radius);
            BlockPos spawnPos = new BlockPos(x, y = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = pos.m_123343_() + (int)(Math.sin(angle) * (double)radius)), z);
            if (!world.m_46859_(spawnPos) || !world.m_8055_(spawnPos.m_7495_()).m_60804_((BlockGetter)world, spawnPos.m_7495_())) continue;
            if (world.m_5822_().nextFloat() > 0.5f) {
                entity = new Tier5BloodHordeEntity(ModEntities.T5_BLOOD_HORDE, (Level)world);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 24000, 3));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 24000, 7));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 24000, 0));
                entity.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.m_7967_((Entity)entity);
                continue;
            }
            entity = new Tier5BloodSkeletonEntity(ModEntities.T5_BLOOD_SKELETON, (Level)world);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 24000, 3));
            entity.m_7292_(new MobEffectInstance(ModEffects.CORRUPTION, 24000, 7));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 24000, 0));
            entity.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, random.nextFloat() * 360.0f, 0.0f);
            world.m_7967_((Entity)entity);
        }
        data.setResult(InteractionResult.SUCCESS);
    }

    public static int calculateGradualTimeIncrease(int timeLeftInTicks, int playerCount) {
        int timeLeftInSeconds = timeLeftInTicks / 20;
        int maxTimeInSeconds = 900;
        int maxAddTimeInTicks = Math.max(40, 120 - (playerCount - 1) * 10);
        float fraction = 1.0f - (float)timeLeftInSeconds / (float)maxTimeInSeconds;
        return Math.max(0, Math.round((float)maxAddTimeInTicks * fraction));
    }

    public static void updateFracturedObeliskObfuscation(CorruptedObjective objective) {
        WoldCommonEvents.FRACTURED_OBELISK_UPDATE.register((Object)objective, data -> {
            if (data.getWorld().m_46467_() % 20L == 0L) {
                float obfuscation = 1.0f - (((CorruptedObjective.CData)((Object)((Object)objective.get(CorruptedObjective.DATA)))).hasCompletedInitial() ? (float)((Integer)((CorruptedObjective.CData)((Object)((Object)objective.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.SECONDARY_COUNT)).intValue() / (float)((Integer)((CorruptedObjective.CData)((Object)((Object)objective.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.SECONDARY_TARGET)).intValue() : (float)((Integer)((CorruptedObjective.CData)((Object)((Object)objective.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.COUNT)).intValue() / (float)((Integer)((CorruptedObjective.CData)((Object)((Object)objective.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.TARGET)).intValue());
                FracturedObeliskTileEntity tile = data.getEntity();
                tile.setInitialCompletion(((CorruptedObjective.CData)((Object)((Object)objective.get(CorruptedObjective.DATA)))).hasCompletedInitial());
                tile.setPercentObfuscated(Math.min(1.0f, obfuscation));
            }
        });
    }

    public static void summonRoofSpikes(VirtualWorld world, Player player, int radius, int tickInterval, float chanceToSummon) {
        if (player.f_19797_ % tickInterval == 0) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            if (world.m_5822_().nextFloat() < chanceToSummon) {
                mutable.m_122169_(player.m_20185_() + (double)world.m_5822_().nextInt(radius * 2) - (double)radius, 64.0, player.m_20189_() + (double)world.m_5822_().nextInt(radius * 2) - (double)radius);
                double angle = world.m_5822_().nextDouble() * 1.5 * Math.PI;
                double dx = Math.cos(angle);
                double dz = Math.sin(angle);
                double dy = 0.5 + world.m_5822_().nextDouble() * 0.3;
                int length = 15 + world.m_5822_().nextInt(10);
                float maxRadius = 1.5f + world.m_5822_().nextFloat();
                double px = mutable.m_123341_();
                double py = mutable.m_123342_();
                double pz = mutable.m_123343_();
                BlockPos lastBlock = null;
                for (int i = 0; i < length; ++i) {
                    int layerRadius;
                    float progress = (float)i / (float)length;
                    if (i >= length - 2) {
                        layerRadius = 0;
                    } else {
                        float rad = (float)Math.pow(1.0 - (double)progress, 1.2);
                        layerRadius = Math.max(1, Math.round(maxRadius * rad));
                    }
                    BlockPos center = new BlockPos(px, py, pz);
                    for (int x = -layerRadius; x <= layerRadius; ++x) {
                        for (int z = -layerRadius; z <= layerRadius; ++z) {
                            BlockPos pos;
                            double dist = Math.sqrt(x * x + z * z);
                            if (!(dist <= (double)layerRadius + 0.2 + (world.m_5822_().nextDouble() - 0.5) * 0.3) || !world.m_46859_(pos = center.m_142082_(x, 0, z))) continue;
                            BlockState block = world.m_5822_().nextFloat() < 0.15f ? Blocks.f_50723_.m_49966_() : Blocks.f_50080_.m_49966_();
                            world.m_7731_(pos, block, 3);
                            lastBlock = pos;
                        }
                    }
                    px += dx * 0.8;
                    py += dy * 0.8;
                    pz += dz * 0.8;
                }
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MonolithIgniteMessage((BlockPos)mutable));
                if (lastBlock != null && world.m_5822_().nextFloat() > 0.5f) {
                    world.m_7731_(lastBlock, ModBlocks.NULLITE_ORE.m_49966_(), 3);
                }
            }
        }
    }

    public static void summonLightning(VirtualWorld world, Player player, int radius, int tickInterval, float chanceToSummon) {
        if (player.f_19797_ % tickInterval == 0 && world.m_5822_().nextFloat() < chanceToSummon) {
            BlockPos strikePos = new BlockPos(player.m_20185_() + (double)world.m_5822_().nextInt(radius * 2) - (double)radius, 64.0, player.m_20189_() + (double)world.m_5822_().nextInt(radius * 2) - (double)radius);
            LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)world);
            if (lightning != null) {
                lightning.m_6027_((double)strikePos.m_123341_(), (double)strikePos.m_123342_(), (double)strikePos.m_123343_());
                world.m_7967_((Entity)lightning);
            }
        }
    }

    public static void summonVoidSlashes(CorruptedObjective objective, VirtualWorld world, @NotNull Player player, int radius, int tickInterval, float chanceToSummon) {
        if (player.f_19797_ % tickInterval == 0 && ((CorruptedObjective.CData)((Object)objective.get(CorruptedObjective.DATA))).hasCompletedInitial() && world.m_5822_().nextFloat() < chanceToSummon) {
            int minDistance = 6;
            double angle = world.m_5822_().nextDouble() * 2.0 * Math.PI;
            double distance = (double)minDistance + world.m_5822_().nextDouble() * (double)(radius - minDistance);
            int xOffset = (int)(Math.cos(angle) * distance);
            int zOffset = (int)(Math.sin(angle) * distance);
            BlockPos base = new BlockPos(player.m_20185_() + (double)xOffset, 64.0, player.m_20189_() + (double)zOffset);
            CorruptedVaultHelper.generateSlash(world, base);
        }
    }

    public static void breakVaultPortal(VirtualWorld world, Vault vault, Player player) {
        TickClock tickClock = (TickClock)vault.get(Vault.CLOCK);
        if (tickClock.has(TickClock.PAUSED) && tickClock.has(TickClock.VISIBLE)) {
            vault.ifPresent(Vault.WORLD, manager -> {
                Object patt26172$temp = manager.get(WorldManager.PORTAL_LOGIC);
                if (!(patt26172$temp instanceof ClassicPortalLogic)) {
                    return;
                }
                ClassicPortalLogic logic = (ClassicPortalLogic)patt26172$temp;
                if (logic.getPlayerStartPos(vault).map(start -> player.f_19853_.m_46472_().equals((Object)world.m_46472_()) && player.m_20238_(Vec3.m_82512_((Vec3i)start)) > 225.0).orElse(false).booleanValue()) {
                    logic.getPortals().forEach(portal -> {
                        BlockPos min = (BlockPos)portal.get(PortalData.MIN);
                        BlockPos max = (BlockPos)portal.get(PortalData.MAX);
                        if (world.m_8055_(min).m_60795_()) {
                            return;
                        }
                        for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
                            for (int y = min.m_123342_(); y <= max.m_123342_(); ++y) {
                                for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                                    BlockPos current = new BlockPos(x, y, z);
                                    world.m_46961_(current, false);
                                }
                            }
                        }
                        player.m_6352_((Component)new TextComponent("You sense a portal shattering").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0xAA0000)), Util.f_137441_);
                        player.m_6330_(SoundEvents.f_12513_, SoundSource.BLOCKS, 0.5f, 0.7f);
                        Entity entityType = ModEntities.T5_BLOOD_HORDE.m_20615_((Level)world);
                        if (entityType != null) {
                            entityType.m_20035_(min, 0.0f, 0.0f);
                            world.m_7967_(entityType);
                        }
                    });
                    ((TickClock)vault.get(Vault.CLOCK)).remove(TickClock.PAUSED);
                }
            });
        }
    }

    public static void preventFruits(CorruptedObjective obj, Vault vault) {
        CommonEvents.FRUIT_EATEN.register((Object)obj, data -> {
            Vault playerVault = VaultUtils.getVault((Level)data.getPlayer().m_183503_()).orElse(null);
            if (playerVault != null && playerVault.equals(vault)) {
                data.setTime(0);
                data.getPlayer().m_5661_((Component)new TextComponent("Seems pointless...").m_130940_(ChatFormatting.RED), true);
            }
        });
    }

    public static void removeLocatorItem(CorruptedObjective obj, Vault vault) {
        CommonEvents.LISTENER_LEAVE.register((Object)obj, data -> {
            if (data.getVault() == vault && data.getListener() instanceof Runner) {
                data.getListener().getPlayer().ifPresent(player -> {
                    for (InventoryUtil.ItemAccess items : InventoryUtil.findAllItems((Player)player)) {
                        ItemStack stack = items.getStack();
                        if (!(stack.m_41720_() instanceof LocatorItem)) continue;
                        items.setStack(ItemStack.f_41583_);
                    }
                });
            }
        });
    }

    public static void generateVaultModifierThresholds(CorruptedObjective obj, Random random) {
        float baseStart = 0.5f;
        int maxThresholds = 100;
        float maxCorruption = 25.0f;
        for (int i = 0; i < maxThresholds; ++i) {
            ((FloatList)((Object)obj.get(CorruptedObjective.CORRUPTION_THRESHOLDS))).add(Float.valueOf(baseStart += random.nextFloat() > 0.5f ? 0.6f : 0.8f));
            if (baseStart > 10.0f) {
                baseStart -= random.nextFloat() > 0.5f ? 0.2f : 0.35f;
            }
            if (baseStart > maxCorruption) break;
        }
    }

    public static void handleObeliskUsage(CorruptedObjective obj, VirtualWorld world, Vault vault) {
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of((Block)ModBlocks.FRACTURED_OBELISK).register((Object)obj, data -> {
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            BlockPos pos = data.getPos();
            if (data.getState().m_61143_((Property)ObeliskBlock.HALF) == DoubleBlockHalf.UPPER && world.m_8055_(pos = pos.m_7495_()).m_60734_() != ModBlocks.FRACTURED_OBELISK) {
                data.setResult(InteractionResult.SUCCESS);
            }
            if (((Listeners)vault.get(Vault.LISTENERS)).getObjectivePriority(data.getPlayer().m_142081_(), (Objective)obj) != 0) {
                return;
            }
            CorruptedVaultHelper.playActivationEffects(world, pos);
            for (Objective objective : (Objective.ObjList)obj.get(CorruptedObjective.CHILDREN)) {
                if (!(objective instanceof KillBossObjective)) continue;
                KillBossObjective killBoss = (KillBossObjective)objective;
                killBoss.set(KillBossObjective.BOSS_POS, (Object)pos);
            }
            if (pos.m_123342_() < 64) {
                CorruptedVaultHelper.handleObeliskBelow(data, vault, world, pos);
            } else {
                CorruptedVaultHelper.handleObeliskAbove(data, world, pos, obj);
            }
        });
    }

    public static void handleMonolithUsage(CorruptedObjective obj, VirtualWorld world, Vault vault) {
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of((Block)ModBlocks.MONOLITH_CONTROLLER).register((Object)obj, data -> {
            boolean isFromThisVault;
            Player player;
            ItemStack item;
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            BlockPos pos = data.getPos();
            if (data.getState().m_61143_(MonolithControllerBlock.HALF) == DoubleBlockHalf.UPPER && world.m_8055_(pos = pos.m_7495_()).m_60734_() != ModBlocks.MONOLITH_CONTROLLER) {
                data.setResult(InteractionResult.SUCCESS);
            }
            if (!(item = (player = data.getPlayer()).m_21205_()).m_41782_()) {
                return;
            }
            CompoundTag nbt = item.m_41783_();
            boolean bl = isFromThisVault = nbt != null && nbt.m_128342_("VaultID").equals(vault.get(Vault.ID));
            if (item.m_41720_() == ModItems.RUINED_ESSENCE && (Integer)((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.COUNT) < (Integer)((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.TARGET) && isFromThisVault) {
                if (!player.m_150110_().f_35937_) {
                    item.m_41774_(1);
                }
                ((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).set(CorruptedObjective.CData.COUNT, (Integer)((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.COUNT) + 1);
                world.m_5594_(null, pos, SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 0.75f * world.f_46441_.nextFloat() + 0.25f);
                if (((Integer)((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.COUNT)).intValue() == ((Integer)((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.TARGET)).intValue()) {
                    ((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).set(CorruptedObjective.CData.INITIAL_COMPLETION, true);
                    vault.ifPresent(Vault.CLOCK, clock -> clock.remove(TickClock.VISIBLE));
                }
            }
        });
    }

    public static void generateObjectiveBlocks(CorruptedObjective obj, VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register((Object)obj, data -> obj.ifPresent(CorruptedObjective.OBJECTIVE_PROBABILITY, probability -> data.setProbability((double)probability.floatValue())));
        obj.registerObjectiveTemplate(world, vault);
    }

    public static void handleKillTimeExtensions(CorruptedObjective obj, VirtualWorld world, Vault vault) {
        CommonEvents.ENTITY_DEATH.register((Object)obj, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            if (((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).hasCompletedInitial()) {
                return;
            }
            if (event.getSource().m_7639_() instanceof Player && CorruptedVaultHelper.eligibleForExtraTime(vault)) {
                int timeLeft = (Integer)((TickClock)vault.get(Vault.CLOCK)).get(TickClock.DISPLAY_TIME);
                int playerCount = ((Listeners)vault.get(Vault.LISTENERS)).getAll().size();
                int increase = CorruptedVaultHelper.calculateGradualTimeIncrease(timeLeft, playerCount);
                ((TickClock)vault.get(Vault.CLOCK)).addModifier((ClockModifier)new KillMobTimeExtension(increase));
                if (increase != 0) {
                    ((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).set(CorruptedObjective.CData.TIME_ADDEND_TICKS, (Integer)((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).get(CorruptedObjective.CData.TIME_ADDEND_TICKS) + increase);
                    ((CorruptedObjective.CData)((Object)((Object)obj.get(CorruptedObjective.DATA)))).set(CorruptedObjective.CData.DISPLAY_OVERLAY_TICK, 40);
                }
            } else {
                event.getEntity().f_19853_.m_5594_(null, event.getEntity().m_142538_(), ModSounds.ARTIFACT_BOSS_CATALYST_HIT_WRONG, SoundSource.HOSTILE, 1.2f, 0.75f * world.f_46441_.nextFloat() + 0.65f);
            }
        });
    }

    public static void generateMonolithRoom(CorruptedObjective obj, Vault vault) {
        CommonEvents.LAYOUT_TEMPLATE_GENERATION.register((Object)obj, data -> {
            if (data.getVault() == vault && data.getPieceType() == VaultLayout.PieceType.ROOM) {
                Direction facing = (Direction)((WorldManager)data.getVault().get(Vault.WORLD)).get(WorldManager.FACING);
                RegionPos back = data.getRegion().add(facing, -((Integer)data.getLayout().get(ClassicInfiniteLayout.TUNNEL_SPAN) + 1));
                if (back.m_123341_() == 0 && back.m_123343_() == 0) {
                    TemplatePoolKey key = (TemplatePoolKey)VaultRegistry.TEMPLATE_POOL.getKey(VaultMod.id((String)"vault/rooms/special/lost_void"));
                    if (key == null) {
                        return;
                    }
                    data.setTemplate(data.getLayout().getRoom((TemplatePool)key.get((Version)vault.get(Vault.VERSION)), vault, (Version)vault.get(Vault.VERSION), data.getRegion(), data.getRandom(), data.getSettings()));
                    ResourceLocation theme = (ResourceLocation)((WorldManager)vault.get(Vault.WORLD)).get(WorldManager.THEME);
                    ResourceLocation id = new ResourceLocation(theme.toString().replace("classic_vault_", "universal_"));
                    PaletteKey palette = (PaletteKey)VaultRegistry.PALETTE.getKey(id);
                    if (palette != null) {
                        data.getSettings().addProcessor((Palette)palette.get(Version.latest()));
                    }
                }
            }
        });
    }

    public static void generateRandomObelisks(CorruptedObjective obj, VirtualWorld world) {
        CommonEvents.TEMPLATE_GENERATION.in((LevelWriter)world).at(TemplateGenerationEvent.Phase.POST).register((Object)obj, data -> {
            if (data.getTemplate().getParent() instanceof EmptyTemplate) {
                return;
            }
            int attemptsPerChunk = 1;
            for (int i = 0; i < attemptsPerChunk; ++i) {
                int x = ThreadLocalRandom.current().nextInt(16) + data.getChunkPos().f_45578_ * 16;
                int z = ThreadLocalRandom.current().nextInt(16) + data.getChunkPos().f_45579_ * 16;
                int y = 64 + ThreadLocalRandom.current().nextInt(16);
                BlockPos pos = new BlockPos(x, y, z);
                ServerLevelAccessor serverLevelAccessor = data.getWorld();
                BlockState state = serverLevelAccessor.m_8055_(pos);
                if (state.m_60734_() != Blocks.f_50016_ || !serverLevelAccessor.m_8055_(pos.m_7494_()).m_60795_() || !serverLevelAccessor.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)serverLevelAccessor, pos, Direction.UP)) continue;
                IZonedWorld.runWithBypass((Object)world, (boolean)true, () -> {
                    PartialTile tile = PartialTile.of((PartialBlockState)PartialBlockState.of((Block)ModBlocks.FRACTURED_OBELISK), (PartialCompoundNbt)PartialCompoundNbt.empty(), (BlockPos)pos);
                    tile.place((CommonLevelAccessor)serverLevelAccessor, pos, 3);
                    ((CorruptedObjective.CData)((Object)((Object)((Object)obj.get(CorruptedObjective.DATA))))).set(CorruptedObjective.CData.SPAWNED_OBELISKS, (Integer)((CorruptedObjective.CData)((Object)((Object)((Object)obj.get(CorruptedObjective.DATA))))).get(CorruptedObjective.CData.SPAWNED_OBELISKS) + 1);
                });
            }
        });
    }

    public static void setBaseVaultTimer(Vault vault) {
        vault.ifPresent(Vault.CLOCK, clock -> {
            if (clock instanceof TickTimer && (Integer)clock.get(TickClock.GLOBAL_TIME) < 5) {
                clock.set(TickTimer.DISPLAY_TIME, (Object)6000);
            }
        });
    }

    public static void summonWithers(VirtualWorld world, @NotNull ServerPlayer player, int radius, int amount) {
        for (int i = 0; i < amount; ++i) {
            BlockPos spawnPos = new BlockPos(player.m_20185_() + (double)world.m_5822_().nextInt(radius * 2) - (double)radius, 72.0, player.m_20189_() + (double)world.m_5822_().nextInt(radius * 2) - (double)radius);
            WitherBoss entity = new WitherBoss(EntityType.f_20496_, (Level)world);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, Integer.MAX_VALUE, 5));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Integer.MAX_VALUE, 1));
            entity.m_20035_(spawnPos, 0.0f, 0.0f);
            world.m_7967_((Entity)entity);
        }
    }

    public static void checkCorruptionEvents(CorruptedObjective obj, Vault vault, VirtualWorld world, float corruption) {
        Iterator iterator = ((FloatList)((Object)obj.get(CorruptedObjective.CORRUPTION_THRESHOLDS))).iterator();
        while (iterator.hasNext()) {
            Float threshold = (Float)iterator.next();
            if (!(corruption >= threshold.floatValue()) || ((FloatList)((Object)obj.get(CorruptedObjective.ACTIVE_THRESHOLDS))).contains(threshold)) continue;
            if (world.m_8890_() == null) {
                return;
            }
            ChunkRandom random = ChunkRandom.any();
            random.setBlockSeed(((Long)vault.get(Vault.SEED)).longValue(), world.m_8890_().m_142538_(), 90039737L);
            List modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom((ResourceLocation)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.CORRUPTED_MODIFIER_POOL), ((VaultLevel)vault.get(Vault.LEVEL)).get(), (RandomSource)random);
            for (VaultModifier mod : modifiers) {
                ((Modifiers)vault.get(Vault.MODIFIERS)).addModifier(mod, 1, true, (RandomSource)ChunkRandom.any());
                world.m_6907_().forEach(player -> player.m_6352_((Component)mod.getChatDisplayNameComponent(1).m_6881_().m_7220_((Component)new TextComponent(" has been applied.").m_130940_(ChatFormatting.RED)), Util.f_137441_));
            }
            ((FloatList)((Object)obj.get(CorruptedObjective.ACTIVE_THRESHOLDS))).add(threshold);
            break;
        }
        if (corruption > 25.0f && ((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).hasCompletedInitial()) {
            ((Listeners)vault.get(Vault.LISTENERS)).getAll().forEach(listener -> listener.getPlayer().ifPresent(player -> CorruptedVaultHelper.reducePlayerHealth(player, 0.1f, 2, 400)));
        }
    }

    public static void tickCorruption(CorruptedObjective obj, Vault vault, float currentMultiplier) {
        if (!((TickClock)vault.get(Vault.CLOCK)).has(TickClock.PAUSED)) {
            ((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).set(CorruptedObjective.CData.CORRUPTION, Float.valueOf((float)((Integer)((TickClock)vault.get(Vault.CLOCK)).get(TickClock.LOGICAL_TIME)).intValue() / 2500.0f * currentMultiplier));
        }
    }

    public static float setupVaultObjectiveValues(CorruptedObjective obj, VirtualWorld world, Vault vault) {
        int playerCount = ((Listeners)vault.get(Vault.LISTENERS)).getAll().size();
        int baseTarget1 = (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.BASE_TARGET);
        int baseTarget2 = (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.SECONDARY_BASE_TARGET);
        ((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).set(CorruptedObjective.CData.TARGET, baseTarget1 + playerCount * 5 - 5);
        ((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).set(CorruptedObjective.CData.SECONDARY_TARGET, baseTarget2 + (playerCount * 5 - 5));
        float corruptionMultiplier = 1.0f + (float)playerCount * 0.2f;
        if ((Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.SPAWNED_OBELISKS) < (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.SECONDARY_TARGET)) {
            ((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).set(CorruptedObjective.CData.SECONDARY_TARGET, (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.SPAWNED_OBELISKS) - 10);
        }
        if ((Integer)((TickClock)vault.get(Vault.CLOCK)).get(TickClock.DISPLAY_TIME) < 0) {
            corruptionMultiplier += 1.0f;
            ((Listeners)vault.get(Vault.LISTENERS)).getAll().forEach(listener -> listener.getPlayer().ifPresent(player -> {
                if (player.f_19797_ % 600 == 0) {
                    player.m_7292_(new MobEffectInstance(ModEffects.BLEED, 300, 1));
                }
            }));
        }
        if (((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).hasCompletedInitial()) {
            corruptionMultiplier += 1.0f;
        }
        return corruptionMultiplier;
    }

    public static void tickDisplayOverlay(CorruptedObjective obj, VirtualWorld world, Vault vault) {
        if ((Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.DISPLAY_OVERLAY_TICK) != 0) {
            ((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).set(CorruptedObjective.CData.DISPLAY_OVERLAY_TICK, (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.DISPLAY_OVERLAY_TICK) - 1);
            if ((Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.DISPLAY_OVERLAY_TICK) == 0) {
                ((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).set(CorruptedObjective.CData.TIME_ADDEND_TICKS, 0);
            }
        }
        if ((Integer)((TickClock)vault.get(Vault.CLOCK)).get(TickClock.DISPLAY_TIME) == 0) {
            for (Listener listener : ((Listeners)vault.get(Vault.LISTENERS)).getAll()) {
                listener.getPlayer().ifPresent(serverPlayer -> world.m_5594_(null, serverPlayer.m_142538_(), SoundEvents.f_12556_, SoundSource.HOSTILE, 0.4f, 0.75f));
            }
        }
    }

    public static boolean shouldDisplayEscapePrompt(CorruptedObjective obj) {
        return (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.COUNT) >= (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.TARGET) && (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.TIME_TICKED_FAKE) == 401;
    }

    private static void reducePlayerHealth(ServerPlayer player, float percentageToRemove, int minReduction, int interval) {
        AttributeInstance attributeInstance;
        if (player.f_19797_ % interval == 0 && (attributeInstance = player.m_21051_(Attributes.f_22276_)) != null) {
            if (attributeInstance.m_22135_() < 10.0) {
                return;
            }
            AttributeModifier existingModifier = attributeInstance.m_22111_(HEALTH_REDUCTION_UUID);
            double reductionAmount = 0.0;
            if (existingModifier != null) {
                reductionAmount += existingModifier.m_22218_();
                attributeInstance.m_22120_(HEALTH_REDUCTION_UUID);
            }
            attributeInstance.m_22125_(new AttributeModifier(HEALTH_REDUCTION_UUID, "CorruptedVaultHealthReduction", reductionAmount -= Math.max((double)minReduction, attributeInstance.m_22135_() * (double)percentageToRemove), AttributeModifier.Operation.ADDITION));
            player.m_5661_((Component)new TextComponent("Your life seems to be slowly withering away..").m_130940_(ChatFormatting.RED), true);
        }
    }

    public static void removeHealthReductionAttribute(CorruptedObjective obj, Vault vault) {
        CommonEvents.LISTENER_LEAVE.register((Object)obj, data -> {
            if (data.getVault() == vault && data.getListener() instanceof Runner) {
                data.getListener().getPlayer().ifPresent(player -> {
                    AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22276_);
                    if (attributeInstance != null) {
                        attributeInstance.m_22120_(HEALTH_REDUCTION_UUID);
                    }
                });
            }
        });
    }

    public static void tickFakeVictory(CorruptedObjective obj) {
        ((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).set(CorruptedObjective.CData.TIME_TICKED_FAKE, (Integer)((CorruptedObjective.CData)((Object)obj.get(CorruptedObjective.DATA))).get(CorruptedObjective.CData.TIME_TICKED_FAKE) + 1);
    }
}

