/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.woldsvaults.api.util;

import iskallia.vault.config.ShopPedestalConfig;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import xyz.iwolfking.woldsvaults.init.ModBlocks;

public class ShopPedestalHelper {
    public static ShopPedestalConfig.ShopOffer generatePedestalOffer(BlockState state, VirtualWorld world, Vault vault, RandomSource random) {
        int level = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
        return ShopPedestalHelper.getOffer(state, level, random);
    }

    public static ShopPedestalConfig.ShopOffer generatePedestalOffer(BlockState state, Level world, RandomSource random) {
        Vault vault = ServerVaults.get((Level)world).orElse(null);
        if (vault == null) {
            return ModConfigs.SHOP_PEDESTAL.getForLevel(0, random);
        }
        int level = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
        return ShopPedestalHelper.getOffer(state, level, random);
    }

    private static ShopPedestalConfig.ShopOffer getOffer(BlockState state, int level, RandomSource random) {
        if (state.m_60734_().equals(ModBlocks.ETCHING_PEDESTAL)) {
            return xyz.iwolfking.woldsvaults.init.ModConfigs.ETCHING_SHOP_PEDESTAL.getForLevel(level, random);
        }
        if (state.m_60734_().equals(ModBlocks.GOD_VENDOR_PEDESTAL)) {
            return xyz.iwolfking.woldsvaults.init.ModConfigs.GOD_SHOP_PEDESTAL.getForLevel(level, random);
        }
        if (state.m_60734_().equals(ModBlocks.BLACKSMITH_VENDOR_PEDESTAL)) {
            return xyz.iwolfking.woldsvaults.init.ModConfigs.BLACKSMITH_SHOP_PEDESTAL.getForLevel(level, random);
        }
        if (state.m_60734_().equals(ModBlocks.RARE_VENDOR_PEDESTAL)) {
            return xyz.iwolfking.woldsvaults.init.ModConfigs.RARE_SHOP_PEDESTAL.getForLevel(level, random);
        }
        if (state.m_60734_().equals(ModBlocks.OMEGA_VENDOR_PEDESTAL)) {
            return xyz.iwolfking.woldsvaults.init.ModConfigs.OMEGA_SHOP_PEDESTAL.getForLevel(level, random);
        }
        if (state.m_60734_().equals(ModBlocks.SPOOKY_VENDOR_PEDESTAL)) {
            return xyz.iwolfking.woldsvaults.init.ModConfigs.SPOOKY_SHOP_PEDESTAL.getForLevel(level, random);
        }
        if (state.m_60734_().equals(ModBlocks.CARD_VENDOR_PEDESTAL)) {
            return xyz.iwolfking.woldsvaults.init.ModConfigs.CARD_SHOP_PEDESTAL.getForLevel(level, random);
        }
        return ModConfigs.SHOP_PEDESTAL.getForLevel(level, random);
    }
}

